package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.ContextCoverageItem;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsKeywords;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 20.08.15.
 *https://st.yandex-team.ru/TESTIRT-6760
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Проверка корректности структуры ContextCoveragе.")
@Issue("https://st.yandex-team.ru/DIRECT-45134")
@RunWith(Parameterized.class)
public class BidsGetContextCoverageStructureTest {

    private static final String KEYWORD = BidsKeywords.WITH_POKAZOMETER_DATA;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(BidsLogins.BIDS_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long keywordID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocol;
    private GetResponse getResponse;

    @Parameterized.Parameters(name = "Protocol = {0}")
    public static Collection api_protocol() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createKeyword() {
        long campaignId = api.as(BidsLogins.BIDS_CLIENT).userSteps.campaignSteps().addDefaultTextCampaignWithIndependentStrategies();

        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(adGroupID, KEYWORD);
    }

    @Before
    public void getBids() {
        getResponse  = api.protocol(protocol).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.CONTEXT_COVERAGE),
                BidsLogins.BIDS_CLIENT
        );
        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("в ответе присутствует ContextCoverage", getResponse.getBids().get(0).getContextCoverage(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1222")
    public void checkProbabilitySize(){
        List<ContextCoverageItem> gotContextCoverage = getResponse.getBids().get(0).getContextCoverage().getValue().getItems();
        int[] probability = gotContextCoverage.stream().mapToInt(contextCoverage -> contextCoverage.getProbability().intValue()).toArray();
        assertThat("размер Items и Probability совпадают", probability.length, equalTo(gotContextCoverage.size()));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1225")
    public void checkPriceSize(){
        List<ContextCoverageItem> gotContextCoverage = getResponse.getBids().get(0).getContextCoverage().getValue().getItems();
        long[] prices = gotContextCoverage.stream().mapToLong(ContextCoverageItem::getPrice).toArray();
        assertThat("размер Price и Items совпадают", prices.length, equalTo(gotContextCoverage.size()));
    }
}
