package ru.yandex.autotests.direct.api.bids.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 25.07.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class BidsGetInvalidRequestTest {
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1241")
    public void soapGetWithEmptyParams(){
        //testplan: string № 5
        GetRequestMap params = new GetRequestMap().withAllFieldNames();
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                        )

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1238")
    public void jsonGetWithEmptyParams(){
        //testplan: string № 5
        GetRequestMap params = new GetRequestMap().withAllFieldNames();
        api.protocol(ProtocolType.JSON).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                )

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1242")
    public void soapGetWithEmptySelectionCriteria(){
        //testplan: string № 6
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap().withAllFieldNames().withSelectionCriteria(null),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                        )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1243")
    public void jsonGetWithEmptySelectionCriteria(){
        //testplan: string № 6
        api.protocol(ProtocolType.JSON).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap().withAllFieldNames().withSelectionCriteria(null),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1239")
    public void soapGetWithNullSelecrionCriteriaAndNullFieldNames(){
            //testplan: string № 20
            api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                    new GetRequestMap().withAllFieldNames(),
                    BidsLogins.BIDS_CLIENT,
                    new Api5Error(8000,
                            Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                            capitalize(GetRequestMap.SELECTION_CRITERIA))
            );
        }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1240")
    public void jsonGetWithNullSelecrionCriteriaAndNullFieldNames(){
        //testplan: string № 20
        api.protocol(ProtocolType.JSON).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap().withAllFieldNames(),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA))
        );
    }

}





