package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.ObjectFactory;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 12.08.14.
 * https://st.yandex-team.ru/TESTIRT-2750
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Позитивная проверка бизнес-логики метода.")
@Issue("https://st.yandex-team.ru/DIRECT-29381")
public class BidsGetPositiveTest {

    private static String SUPER = BidsLogins.SUPER;
    private static String CLIENT = BidsLogins.BIDS_CLIENT;
    private static String ANOTHER_CLIENT = BidsLogins.BIDS_ANOTHER_CLIENT;
    private static Long DEFAULT_BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonExistentCampaignID;
    private static Long nonExistentAdGroupID;
    private static Long nonExistentPhraseID;
    private static Long adGroupId11;
    private static Long keywordId11;
    private static Long keywordId12;
    private static Long adGroupId12;
    private static Long adGroupId21;
    private static Long keywordId21;
    private static Long anotherAdGroupId;
    private static Long anotherkeywordId;
    private static Long archiveAdGroupId;
    private static Long archivekeywordId;
    private static Long deletedAdGroupId;
    private static Long deletedkeywordId;
    private static Long campaignId1;
    private static Long campaignId2;
    private static Long anotherCampaignId;
    private static Long deletedCampaignId;
    private static Long archiveCampaignId;
    private static Long autoTargetingKeywordId11;
    private static Long autoTargetingKeywordId12;
    private static Long autoTargetingKeywordId21;
    private static Long anotherClientAutoTargetingKeywordId;
    private static Long archivedAutoTargetingKeywordId;
    private static Long deletedAutoTargetingKeywordId;
    private static Long nonExistentAutoTargetingKeywordId;

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long notClientId = 123l;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);

        //Первая кампания клиента с 2мя объявлениями и 2-мя фразами
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                CLIENT
        );
        adGroupId11 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId11, CLIENT);
        keywordId11 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId11);
        autoTargetingKeywordId11 = api.userSteps.keywordsSteps().addAutotargetingWithBid(CLIENT, adGroupId11, DEFAULT_BID);

        adGroupId12 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId12, CLIENT);
        keywordId12 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId12);
        autoTargetingKeywordId12 = api.userSteps.keywordsSteps().addAutotargetingWithBid(CLIENT, adGroupId12, DEFAULT_BID);

        //Вторая кампания клиента с одной фразой
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId21 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId21, CLIENT);
        keywordId21 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId21);
        autoTargetingKeywordId21 = api.userSteps.keywordsSteps().addAutotargetingWithBid(CLIENT, adGroupId21, DEFAULT_BID);

        //Чужая кампания
        anotherCampaignId = api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupId, ANOTHER_CLIENT);
        anotherkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, anotherAdGroupId);
        anotherClientAutoTargetingKeywordId = api.userSteps.keywordsSteps().addAutotargetingWithBid(ANOTHER_CLIENT, anotherAdGroupId, DEFAULT_BID);

        //Архивная кампания
        archiveCampaignId = api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        archiveAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archiveCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(archiveAdGroupId, ANOTHER_CLIENT);
        archivekeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, archiveAdGroupId);
        archivedAutoTargetingKeywordId = api.userSteps.keywordsSteps().addAutotargetingWithBid(ANOTHER_CLIENT, archiveAdGroupId, DEFAULT_BID);
        api.userSteps.campaignSteps().campaignsSuspend(ANOTHER_CLIENT, archiveCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(ANOTHER_CLIENT, archiveCampaignId);

        //Удаленная кампания
        deletedCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(deletedAdGroupId, CLIENT);
        deletedkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, deletedAdGroupId);
        deletedAutoTargetingKeywordId = api.userSteps.keywordsSteps().addAutotargetingWithBid(CLIENT, deletedAdGroupId, DEFAULT_BID);
        api.userSteps.campaignSteps().campaignsDelete(CLIENT, deletedCampaignId);

        nonExistentCampaignID = deletedCampaignId + 1000000;
        nonExistentAdGroupID = deletedAdGroupId + 1000000;
        nonExistentPhraseID = deletedkeywordId + 1000000;
        nonExistentAutoTargetingKeywordId = nonExistentPhraseID + 1000000;

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1244")
    public void getWithOneKeywordIdsInSelectionCriteria() {
        //testplan: string № 8
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId11)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(Arrays.asList(
                        new BidsGetItemMap().withKeywordId(keywordId11).withBid(DEFAULT_BID).getBean()
                ))
        );
    }

    @Test
    @TestCaseId("2709")
    public void getWithOneAutoTargetingKeywordIdInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(autoTargetingKeywordId11)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(Arrays.asList(new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean()))
        );
    }

    @Test
    @TestCaseId("2710")
    public void getWithOneAutoTargetingKeywordIdAndOneKeywordIdInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordId11, autoTargetingKeywordId12)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId12).getBean()
                        )
                )
        );
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1245")
    public void getWithOneAdGroupIdsInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(adGroupId11)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean()
                        )
                )
        );
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1246")
    public void getWithOneCampaignIdsInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignId1)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId12).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId12).withBid(DEFAULT_BID).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1247")
    public void getWithSomeKeywordIdsInSelectionCriteria() {
        //testplan: string № 10
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(
                                        keywordId11,
                                        keywordId21,
                                        autoTargetingKeywordId11,
                                        autoTargetingKeywordId21
                                )
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId21).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId21).getBean()
                        )
                )
        );
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1248")
    public void getWithSomeAdGroupIdsFromDifferentCampaignsInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        adGroupId11,
                                        adGroupId21
                                )
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId21).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId21).getBean()
                        )
                )
        );
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1249")
    public void getWithSomeCampaignIdsInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        campaignId1,
                                        campaignId2
                                )
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId12).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId12).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId21).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId21).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1250")
    public void getWithSomeKeywordIdsFromDiffGroupsInSelectionCriteria() {
        //testplan: string № 11
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(
                                        keywordId11,
                                        keywordId21,
                                        autoTargetingKeywordId11,
                                        autoTargetingKeywordId12,
                                        autoTargetingKeywordId21
                                )
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId12).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId21).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId21).getBean()
                        )
                )
        );
    }


    @Issues({
            @Issue("https://st.yandex-team.ru/DIRECT-34093"),
            @Issue("https://st.yandex-team.ru/DIRECT-34095")
    })
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1251")
    public void getArchiveCampaignKeywordIds() {
        //testplan: string № 12 , 13
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(archivekeywordId, archivedAutoTargetingKeywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", response.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1252")
    public void getArchiveCampaignAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        archiveAdGroupId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1253")
    public void getArchiveCampaignIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        archiveCampaignId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-34093")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1254")
    public void getNonExistedCampaignKeywordIds() {
        //testplan: string № 12
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId11,
                                                notClientId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assumeThat("вернулся один элемент Bids.", response.getBids(), hasSize(1));
        BeanCompareStrategy strategy = new BeanCompareStrategy()
                .putFieldMatcher(BidFieldEnum.BID.value(), notNullValue());
        assertThat("Значения полей в GetResponse соответсвуют ожидаемым.",
                response.getBids().get(0), beanEquals(
                        (new BidsGetItemMap().withKeywordId(keywordId11)).getBean())
                        .accordingStrategy(strategy).byFields(BidFieldEnum.BID.value()));
    }


    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1255")
    public void getNonExistedCampaignAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        adGroupId11,
                                        notClientId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).withBid(DEFAULT_BID).getBean()
                        )
                )
        );
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1256")
    public void getNonExistedCampaigndIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        campaignId1,
                                        notClientId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId11).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId11).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId12).withBid(DEFAULT_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingKeywordId12).withBid(DEFAULT_BID).getBean()
                        )
                )
        );
    }

    @Issues({
            @Issue("https://st.yandex-team.ru/DIRECT-32959"),
            @Issue("https://st.yandex-team.ru/DIRECT-32960"),
            @Issue("https://st.yandex-team.ru/DIRECT-34222")
    })
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1257")
    public void getWithAllValidFields() {
        //testplan: string № 18
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId21)
                                        .withAdGroupIds(adGroupId21)
                                        .withCampaignIds(campaignId2)
                        )
                        .withFieldNames(
                                BidFieldEnum.BID,
                                BidFieldEnum.KEYWORD_ID,
                                BidFieldEnum.AD_GROUP_ID,
                                BidFieldEnum.CAMPAIGN_ID,
                                BidFieldEnum.CONTEXT_BID,
                                BidFieldEnum.COMPETITORS_BIDS,
                                BidFieldEnum.STRATEGY_PRIORITY,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.CONTEXT_COVERAGE,
                                BidFieldEnum.MIN_SEARCH_PRICE,
                                BidFieldEnum.CURRENT_SEARCH_PRICE
                        ),
                CLIENT
        );
        assumeThat("вернулся один элемент Bids.", getResponse.getBids(), hasSize(1));
        BeanCompareStrategy strategy = new BeanCompareStrategy()
                .putFieldMatcher(BidFieldEnum.CONTEXT_BID.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.COMPETITORS_BIDS.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.STRATEGY_PRIORITY.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.SEARCH_PRICES.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.CONTEXT_COVERAGE.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.MIN_SEARCH_PRICE.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.CURRENT_SEARCH_PRICE.value(), notNullValue())
                .putFieldMatcher(BidFieldEnum.CAMPAIGN_ID.value(), equalTo(campaignId2))
                .putFieldMatcher(BidFieldEnum.AD_GROUP_ID.value(), equalTo(adGroupId21))
                .putFieldMatcher(BidFieldEnum.KEYWORD_ID.value(), equalTo(keywordId21));
        assertThat("Значения полей в GetResponse соответсвуют ожидаемым.",
                getResponse.getBids().get(0),
                beanEquals((new BidsGetItemMap().withKeywordId(keywordId21))
                        .getBean()).accordingStrategy(strategy)
                        .byFields(
                                BidFieldEnum.KEYWORD_ID.value(),
                                BidFieldEnum.CONTEXT_BID.value(),
                                BidFieldEnum.COMPETITORS_BIDS.value(),
                                BidFieldEnum.STRATEGY_PRIORITY.value(),
                                BidFieldEnum.SEARCH_PRICES.value(),
                                BidFieldEnum.CONTEXT_COVERAGE.value(),
                                BidFieldEnum.MIN_SEARCH_PRICE.value(),
                                BidFieldEnum.CURRENT_SEARCH_PRICE.value()));
    }

    @Test
    @TestCaseId("2711")
    public void getAutoTargetingWithAllValidFields() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(autoTargetingKeywordId21)
                                        .withAdGroupIds(adGroupId21)
                                        .withCampaignIds(campaignId2)
                        )
                        .withFieldNames(
                                BidFieldEnum.BID,
                                BidFieldEnum.KEYWORD_ID,
                                BidFieldEnum.AD_GROUP_ID,
                                BidFieldEnum.CAMPAIGN_ID,
                                BidFieldEnum.CONTEXT_BID,
                                BidFieldEnum.COMPETITORS_BIDS,
                                BidFieldEnum.STRATEGY_PRIORITY,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.CONTEXT_COVERAGE,
                                BidFieldEnum.MIN_SEARCH_PRICE,
                                BidFieldEnum.CURRENT_SEARCH_PRICE
                        ),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap()
                                        .withBid(DEFAULT_BID)
                                        .withContextBid(DEFAULT_BID)
                                        .withStrategyPriority(new ObjectFactory().createBidGetItemStrategyPriority(PriorityEnum.NORMAL))
                                        .withContextCoverage(new ObjectFactory().createBidGetItemContextCoverage(null))
                                        .withMinSearchPrice(new ObjectFactory().createBidGetItemCurrentSearchPrice(DEFAULT_BID))
                                        .withCurrentSearchPrice(new ObjectFactory().createBidGetItemCurrentSearchPrice(null))
                                        .withCampaignId(campaignId2)
                                        .withAdGroupId(adGroupId21)
                                        .withKeywordId(autoTargetingKeywordId21)
                                        .getBean()
                        )
                )
        );
    }

    @Issues({
            @Issue("https://st.yandex-team.ru/DIRECT-34093"),
            @Issue("https://st.yandex-team.ru/DIRECT-35621")
    })
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1258")
    public void getAnotherClientKeywordIds() {
        //testplan: string № 12
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(anotherkeywordId, anotherClientAutoTargetingKeywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", response.getBids(), hasSize(0));
    }


    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1259")
    public void getAnotherClientAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        anotherAdGroupId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1260")
    public void getAnotherClientCampaignIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        anotherCampaignId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }


    @Issues({
            @Issue("https://st.yandex-team.ru/DIRECT-34093"),
            @Issue("https://st.yandex-team.ru/DIRECT-35621")
    })
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1261")
    public void getOurKeywordIdsWithAnotherClientKeywordIds() {
        //testplan: string № 12
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId11, anotherkeywordId, autoTargetingKeywordId12, anotherClientAutoTargetingKeywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                response.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap()
                                        .withBid(DEFAULT_BID)
                                        .withCurrentSearchPrice(new ObjectFactory().createBidGetItemMinSearchPrice(null))
                                        .withKeywordId(keywordId11)
                                        .getBean(),
                                new BidsGetItemMap()
                                        .withBid(DEFAULT_BID)
                                        .withCurrentSearchPrice(new ObjectFactory().createBidGetItemMinSearchPrice(null))
                                        .withKeywordId(autoTargetingKeywordId12)
                                        .getBean()
                        )
                )
        );
    }


    @Issue("https://st.yandex-team.ru/DIRECT-34095")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1262")
    public void getDeletedKeywordIds() {
        //testplan: string № 13
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(deletedkeywordId, deletedAutoTargetingKeywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE),
                CLIENT);
        assertThat("Вернулось корректное значение GetResponse.", response, equalTo(new GetResponse()));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1263")
    public void getDeletedAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        deletedAdGroupId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1264")
    public void getDeletedCampaignIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        deletedCampaignId
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-34095")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1265")
    public void getNoExistentKeywordIds() {
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(nonExistentPhraseID, nonExistentAutoTargetingKeywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE),
                CLIENT);
        assertThat("Вернулось корректное значение GetResponse.", response, equalTo(new GetResponse()));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1266")
    public void getNoExistentAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        nonExistentAdGroupID
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1267")
    public void getNoExistentCampaignIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        nonExistentCampaignID
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-34095")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1268")
    public void getNegativeKeywordIds() {
        //testplan: string № 13
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(-3L)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE),
                CLIENT
        );
        assertThat("вернулось корректное значение GetResponse.", response, equalTo(new GetResponse()));
    }


    @Issue("https://st.yandex-team.ru/DIRECT-34095")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1269")
    public void getNegativeAdGroupIds() {
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withAdGroupIds(-3L)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE),
                CLIENT
        );
        assertThat("вернулось корректное значение GetResponse.", response, equalTo(new GetResponse()));
    }


    @Issue("https://st.yandex-team.ru/DIRECT-34095")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1270")
    public void getNegativeCamapignIds() {
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(-3L)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CURRENT_SEARCH_PRICE),
                CLIENT
        );
        assertThat("вернулось корректное значение GetResponse.", response, equalTo(new GetResponse()));
    }


    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1271")
    public void getWithAllTypeIdsAndNonExistKeywordIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withAdGroupIds(adGroupId11)
                                        .withCampaignIds(campaignId1)
                                        .withKeywordIds(notClientId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("не вернулось ни одной ставки", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1272")
    public void getWithAllTypeIdsAndNonExistAdGroupIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId11)
                                        .withCampaignIds(campaignId1)
                                        .withAdGroupIds(notClientId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("вернулось верное кол-во элементов Bids.", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1273")
    public void getWithAllTypeIdsAndNonExistCampaignIds() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId11)
                                        .withAdGroupIds(adGroupId11)
                                        .withCampaignIds(notClientId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("вернулось верное кол-во элементов Bids.", getResponse.getBids(), hasSize(0));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-36010")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1274")
    public void getWithSomeIdsOfEveryType() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(
                                                keywordId11,
                                                keywordId12,
                                                keywordId21,
                                                autoTargetingKeywordId12,
                                                autoTargetingKeywordId21,
                                                notClientId)
                                        .withAdGroupIds(
                                                adGroupId11,
                                                adGroupId21,
                                                notClientId)
                                        .withCampaignIds(
                                                campaignId1,
                                                campaignId2,
                                                notClientId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                CLIENT
        );
        assertThat("количество элементов и значения полей в ответе соответствуют ожидаемым",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withBid(DEFAULT_BID).withKeywordId(keywordId11).getBean(),
                                new BidsGetItemMap().withBid(DEFAULT_BID).withKeywordId(keywordId21).getBean(),
                                new BidsGetItemMap().withBid(DEFAULT_BID).withKeywordId(autoTargetingKeywordId21).getBean()
                        )
                )
        );
    }

}
