package ru.yandex.autotests.direct.api.bids.get;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 02.06.14.
 */
@Aqua.Test
@Features(BidsFeatures.SMOKE)
public class BidsGetSmokeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1275")
    public void callBidsGet(){
        Long minBid = MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue();
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        Long keywordId = api.userSteps.keywordsSteps().keywordsAdd(
                BidsLogins.BIDS_CLIENT,
                new KeywordAddMap().defaultKeyword()
                        .withAdGroupId(adGroupId).withBid(minBid)).get(0);
        GetResponse getResponse = api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID),
                BidsLogins.BIDS_CLIENT
        );
        assertThat("вернулось корректное Bid", getResponse.getBids().get(0).getBid(), equalTo(minBid));
    }

}
