package ru.yandex.autotests.direct.api.bids.get;

import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 01.06.15.
 */
@Aqua.Test
@Stories(ApiStories.UNITS)
@Issue("https://st.yandex-team.ru/DIRECT-37056")
@Features(BidsFeatures.GET)
@Description("Проверка списания баллов.")
public class BidsGetUnitsTest {
    private static String client = BidsLogins.UNITS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adGroupId11;
    private static Long campaignId1;
    private static List<Long> keywordIds11;
    private static Long adGroupId12;
    private static List<Long> keywordIds12;
    private static Long campaignId2;
    private static Long adGroupId22;
    private static List<Long> keywordIds22;

    @Rule
    public Trashman trashman = new Trashman(api);

    int GET_COST = 15;
    int GET_COST_KEYWORD = 0;//after DIRECT-46481
    int DEFAULT_FAULT_COST = 50;

    @BeforeClass
    public static void initTest() {
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                client
        );
        adGroupId11 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId11);
        keywordIds11 = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupId11, 2);

        adGroupId12 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId12);
        keywordIds12 = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupId12, 2);

        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId22 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId22);
        keywordIds22 = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupId22, 2);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1276")
    public void getOneBid() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordIds11.get(0))
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + GET_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1277")
    public void getTwoBids() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(
                                        keywordIds11.get(0),
                                        keywordIds11.get(1)
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 2 * GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1278")
    public void getTwoBidsFromTwoBanners() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(
                                        keywordIds11.get(0),
                                        keywordIds22.get(0)
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 2 * GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1279")
    public void getBidsByAdGroupId() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        adGroupId11                               )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 2 * GET_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1280")
    public void getBidsBySomeAdGroupIds() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(
                                        adGroupId11, adGroupId12
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 4 * GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1281")
    public void getBidsByCampaignId() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        campaignId1
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 4 * GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1282")
    public void getBidsBySomeCampaignIds() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(
                                        campaignId1,
                                        campaignId2
                                )
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + 6 * GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1286")
    public void getBidByCampaignIdAndAdGroupIdAndKeywordId() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId1)
                                        .withAdGroupIds(adGroupId11)
                                        .withKeywordIds(keywordIds11.get(0))
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST + GET_COST_KEYWORD));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1283")
    public void getBidByCampaignIdAndKeywordIdAndAnotherAdGroupId() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId1)
                                        .withAdGroupIds(adGroupId12)
                                        .withKeywordIds(keywordIds11.get(0))
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_COST));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1284")
    public void callGetWithZeroUnits() {
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, units);
        units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("у клиента не осталось баллов", units, equalTo(0));
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordIds11.get(0))
                        )
                        .withFieldNames(BidFieldEnum.BID),
                client,
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION)
        );
    }

    /*
  @Test
  @Description("Списываем баллы у главного представителя и делаем вызов обычным представителем, " +
          "должны получить ошибку о нехватке баллов.")
  public void callGetWithZeroRepUnits() {
      int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(BidsLogins.BIDS_CLIENT);
      api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(BidsLogins.BIDS_CLIENT, units);
      units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(BidsLogins.BIDS_CLIENT);
      assumeThat("у клиента не осталось баллов", units, equalTo(0));
      api.as(BidsLogins.BIDS_REP_CLIENT).userSteps.bidsSteps().shouldGetErrorOnBidsGet(
              new GetRequestMap()
                      .withSelectionCriteria(
                              new BidsSelectionCriteriaMap().withKeywordIds(firstBannerPhrases[0].getPhraseID())
                      )
                      .withFieldNames(BidFieldEnum.BID),
              BidsLogins.BIDS_REP_CLIENT,
              new Api5Error(1017, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION)
      );
      api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
  }
       */

    //FAULT

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1285")
    public void getWithFaultError(){
        //testplan: string № 14
        //   https://st.yandex-team.ru/DIRECT-38565
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordIds11.get(0))
                        ),
                client,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(DEFAULT_FAULT_COST));
    }

}
