package ru.yandex.autotests.direct.api.bids.get;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 02.06.14.
 */
@Aqua.Test
@Features(BidsFeatures.BIDS_TC_TORGI)
@Issue("https://st.yandex-team.ru/TESTIRT-7441")
@Description("Проверка работы торгов")
public class BidsMonitorTCTest {
    private static final String LOGIN = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long keywordId;

    @Before
    @Step("Подготовка тестовых данных")
    public void initData() {
        api.userSteps.clientFakeSteps().enableAPI(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, LOGIN);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, LOGIN);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(LOGIN, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1287")
    public void callBidsGet() {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.SEARCH_PRICES),
                BidsLogins.BIDS_CLIENT
        );
        assumeThat("получили не пустой список Bids", getResponse.getBids(), iterableWithSize(greaterThan(0)));
        assumeThat("в первом Bid непустой список SearchPrices", getResponse.getBids().get(0).getSearchPrices()
                , iterableWithSize(greaterThan(0)));
        assertThat("в первом SearchPrices вернулось не пустое значение"
                , getResponse.getBids().get(0).getSearchPrices().get(0).getPrice()
                , greaterThan(0L));
    }
}
