package ru.yandex.autotests.direct.api.bids.get;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;

/**
 * Created by onotole on 27.12.16.
 * https://st.yandex-team.ru/TESTIRT-10840
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("для фраз и автотаргетинга в группах со статусом \"мало показов\" не возвращаются поля CompetitorsBids, SearchPrices и AuctionBids")
@Issue("https://st.yandex-team.ru/DIRECT-61798")
@RunWith(Parameterized.class)
public class GetBsRarelyLoadedHideFieldsTest {
    private static final String CLIENT = BidsLogins.CLIENT_FOR_RUB;
    private static Long keywordId;
    private static Long autoTargetingKeywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public BidFieldEnum bidField;

    @Parameterized.Parameter(1)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "{1} {0}")
    public static Collection<Object[]> testData() {
        List<Object[]> resultData = new ArrayList<>();
        ProtocolType[] protocolTypes = new ProtocolType[]{ProtocolType.SOAP, ProtocolType.JSON};

        Object[][] bidFields = new Object[][]{
                {BidFieldEnum.COMPETITORS_BIDS},
                {BidFieldEnum.SEARCH_PRICES},
                {BidFieldEnum.AUCTION_BIDS}
        };
        for (ProtocolType type : protocolTypes) {
            for (Object[] bid : bidFields) {
                resultData.add(
                        new Object[]{bid[0], type}
                );
            }
        }
        return resultData;
    }

    @BeforeClass
    public static void prepare() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autoTargetingKeywordId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).adGroupsSteps().setBsRarelyLoaded(adGroupId, true);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2655")
    public void hiddenFieldShouldNotBeReturned() {
        GetResponse response = api.protocol(protocolType).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId))
                        .withFieldNames(BidFieldEnum.SERVING_STATUS, bidField)
        );
        assertThat("неотображаемое поле не вернулось",
                response.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withServingStatus(ServingStatusEnum.RARELY_SERVED).getBean()
                        )
                )
        );
    }

    @Test
    @TestCaseId("2712")
    public void hiddenFieldShouldNotBeReturnedForRelevanceMatch() {
        GetResponse response = api.protocol(protocolType).userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(autoTargetingKeywordId)
                ).withFieldNames(BidFieldEnum.SERVING_STATUS, bidField)
        );
        assertThat("неотображаемое поле не вернулось",
                response.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withServingStatus(ServingStatusEnum.RARELY_SERVED).getBean()
                        )
                )
        );
    }
}
