package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 28.12.16.
 * https://st.yandex-team.ru/TESTIRT-10840
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("для ставок редкопоказываемых объявлений некоторые значения возвращаются как nil")
@Issue("https://st.yandex-team.ru/DIRECT-61798")
@RunWith(Parameterized.class)
public class GetBsRarelyLoadedNilTest {
    private static final String CLIENT = BidsLogins.CLIENT_FOR_RUB;
    private static long campaignId;
    private static long adGroupId;
    private static int shard;
    private static long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public BidFieldEnum bidField;

    @Parameterized.Parameter(1)
    public Function<BidGetItem, JAXBElement> getField;

    @Parameterized.Parameters(name = "{0} {1}")
    public static Collection<Object[]> testDate() {
        return Arrays.asList(new Object[][] {
                {BidFieldEnum.CONTEXT_COVERAGE, (Function<BidGetItem, JAXBElement>) BidGetItem::getContextCoverage},
                {BidFieldEnum.MIN_SEARCH_PRICE, (Function<BidGetItem, JAXBElement>) BidGetItem::getMinSearchPrice},
                {BidFieldEnum.CURRENT_SEARCH_PRICE, (Function<BidGetItem, JAXBElement>) BidGetItem::getCurrentSearchPrice}
        });
    }

    @BeforeClass
    public static void prepare() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setBsRarelyLoaded(adGroupId, true);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2656")
    public void someFieldShouldBeReturnedAsNil() {
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withAdGroupIds(adGroupId))
                        .withFieldNames(BidFieldEnum.SERVING_STATUS, bidField)
        );
        assumeThat("bid вернулись", response.getBids(), not(empty()));
        BidGetItem bidGetItem = response.getBids().get(0);
        assumeThat("вернулся bid RarelyServed", bidGetItem.getServingStatus(), equalTo(ServingStatusEnum.RARELY_SERVED));
        assertThat("значение поля вернулось как null", getField.apply(bidGetItem).isNil(), equalTo(true));
    }
}
