package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 26.12.16.
 * https://st.yandex-team.ru/TESTIRT-10840
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("ServingStatus отдается правильно")
@Issue("https://st.yandex-team.ru/DIRECT-61798")
@RunWith(Parameterized.class)
public class GetBsRarelyLoadedTest {
    private static final String CLIENT = BidsLogins.CLIENT_FOR_RUB;
    private static long campaignId;
    private static long adGroupId;
    private static int shard;
    private static long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public boolean bsRarelyLoaded;

    @Parameterized.Parameter(1)
    public ServingStatusEnum expectedServingStatus;

    @Parameterized.Parameters(name = "{1}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {true, ServingStatusEnum.RARELY_SERVED},
                {false, ServingStatusEnum.ELIGIBLE}
        });
    }

    @BeforeClass
    public static void prepare() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2657")
    public void checkServingStatus() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setBsRarelyLoaded(adGroupId, bsRarelyLoaded);
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                    .withSelectionCriteria(
                            new BidsSelectionCriteriaMap()
                                    .withAdGroupIds(adGroupId))
                .withFieldNames(BidFieldEnum.SERVING_STATUS)
        );
        assumeThat("Вернулся непустой набор фраз", response.getBids(), hasSize(1));
        assertThat("вернулось правильное значение SERVING STATUS", response.getBids().get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }
}
