package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.UsersPreselectedData;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by hmepas on 28.11.17
 */
@Aqua.Test
@Stories(ApiStories.UNITS)
@RunWith(Parameterized.class)
@Description("Списание баллов при запросе ключевых слов с данными из БК или ADVQ")
public class GetMoreThan4000KeywordsUnitsTest {

    private static LogSteps log = LogSteps.getLogger(GetMoreThan4000KeywordsUnitsTest.class);

    private static final int GET_COST = 15;
    private static final int ITEM_COST_ON_GET_PER_2000 = 3;

    private static final String LOGIN = UsersPreselectedData.MORE_THAT_4000_KEYWORDS_LOGIN;
    public static final Long[] CAMPAIGN_IDS = UsersPreselectedData.MORE_THAN_4000_KEYWORDS_CAMPAIGN_IDS;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter
    public String message;

    @Parameterized.Parameter(value = 1)
    public BidFieldEnum[] fieldNames;

    @Parameterized.Parameter(value = 2)
    public int costPerExtra2000;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {"Получение каждых 2000 фраз сверх первых двух тысяч, без статистики стоит в баллах: " + ITEM_COST_ON_GET_PER_2000,
                        new BidFieldEnum[] {
                                BidFieldEnum.BID},
                        ITEM_COST_ON_GET_PER_2000},
                // параметром потому что возможно тут будет зависимость от запрашиваемых полей и тогда тест разрастется
        };
        return Arrays.asList(data);
    }

    @Test
    @Description("Получение каждых 2000 фраз сверх первой, стоимость в баллах в зависимости от полей")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3658")
    public void getMoreThat2000KeywordsNoStatTest() {
        api.as(Logins.SUPER_LOGIN, LOGIN);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        final List<BidGetItem> bidGetItems = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withCampaignIds(CAMPAIGN_IDS)
                ).withFieldNames(
                        fieldNames
                ).withPage(new LimitOffsetMap().withLimit(4000L))
        ).getBids();
        assumeThat("вернулось более 4000 фраз", bidGetItems, hasSize(greaterThanOrEqualTo(4000)));

        int size = bidGetItems.size();
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        assertThat(message, unitsBefore - unitsAfter, equalTo(GET_COST + costPerExtra2000 * ( (int) size/2000) ));
    }
}

