package ru.yandex.autotests.direct.api.bids.get;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Негативная проверка валидации полей.")
public class InvalidFieldTypeGetRequestTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static String stringValue = "чика-бум";
    private static long keywordId;
    private static Long adGroupId;
    private static Long campaignID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1289")
    public void tryGetWithSelectionCriteriaArray() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new Long[]{keywordId});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{keywordIds});
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1290")
    public void getWithEmptyArrayOfFieldNames() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new String[]{String.valueOf(keywordId)});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        1
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1291")
    public void tryGetWithFieldNamesNotArray() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new Long[]{keywordId});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), BidFieldEnum.BID.value());
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.FIELD_NAMES)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1292")
    public void tryGetWithFieldNamesArrayOfLong() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new Long[]{keywordId});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new Long[]{123L});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        Api5Error.enumAsParam(BidFieldEnum.class)
                )
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1293")
    public void tryGetWithKeywordIdsNotArray() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS), keywordId);
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.KEYWORDS_IDS)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1288")
    public void tryGetWithKeywordIdsArrayOfString() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new String[]{stringValue});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.KEYWORDS_IDS)
                )
        );
    }


    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1294")
    public void tryGetWithAdGroupIdsNotArray() {
        JSONObject adGroupIds = new JSONObject();
        adGroupIds.put(capitalize(BidsSelectionCriteriaMap.ADGROUP_IDS), adGroupId);
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), adGroupIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.ADGROUP_IDS)
                )
        );
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1295")
    public void tryGetWithAdGroupIdsArrayOfString() {
        JSONObject adGroupIds = new JSONObject();
        adGroupIds.put(capitalize(BidsSelectionCriteriaMap.ADGROUP_IDS),
                new String[]{stringValue});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), adGroupIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.ADGROUP_IDS)
                )
        );
    }


    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1296")
    public void tryGetWithCampaignIdsNotArray() {
        JSONObject campaignIds = new JSONObject();
        campaignIds.put(capitalize(BidsSelectionCriteriaMap.CAMPAIGN_IDS), campaignID);
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), campaignIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.CAMPAIGN_IDS)
                )
        );
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1297")
    public void tryGetWithCampaignIdsArrayOfString() {
        JSONObject campaignIds = new JSONObject();
        campaignIds.put(capitalize(BidsSelectionCriteriaMap.CAMPAIGN_IDS),
                new String[]{stringValue});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), campaignIds);
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.BID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.CAMPAIGN_IDS)
                )
        );
    }

}
