package ru.yandex.autotests.direct.api.bids.get;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 06.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-64386")
@Features(BidsFeatures.GET)
@Description("Проверка пагинации, негативные сценарии")
public class PagerNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(BidsLogins.BIDS_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1305")
    public void zeroLimit() {
        //DIRECT-34629
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(0L)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID)
                        .withPage(new LimitOffsetMap()
                                .withLimit(0l)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1307")
    public void overMaxLimit() {
        //DIRECT-34627
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(0L)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID)
                        .withPage(new LimitOffsetMap()
                                .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH + 1)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE,
                        LimitOffsetMap.LIMIT_MAX_LENGTH)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1309")
    public void negativeLimit() {
        //DIRECT-34626
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(0L)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID)
                        .withPage(new LimitOffsetMap()
                                .withLimit(-1l)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1311")
    public void negativeOffset() {
        //DIRECT-34626
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withCampaignIds(0L)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID)
                        .withPage(new LimitOffsetMap()
                                .withOffset(-1l)),
                new Api5Error(4002,
                        Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)
        );
    }
}
