package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.bids.BidActionResult;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 08.12.15.
 * https://st.yandex-team.ru/TESTIRT-7930
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44733")
@Features(BidsFeatures.GET)
@Description("Проверка пагинации")
@RunWith(Parameterized.class)
public class PagerPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(BidsLogins.BIDS_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long[] campaignIds;

    @Parameterized.Parameter(2)
    public Long[] adGroupIds;

    @Parameterized.Parameter(3)
    public Long[] keywordIds;

    @Parameterized.Parameter(4)
    public Long limit;

    @Parameterized.Parameter(5)
    public Long offset;

    @Parameterized.Parameter(6)
    public List<Long> expectedKeywordIds;

    @Parameterized.Parameter(7)
    public Long limitedBy;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> testDate() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long keywordAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long keywordAdGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2);
        Long autoTargetingAdGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autoTargetingAdGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autoTargetingAdGroupId3 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autoTargetingAdGroupId4 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2);
        Long id1 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        Long id2 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        Long id3 = api.userSteps.keywordsSteps().addDefaultKeyword(keywordAdGroupId);
        Long id4 = api.userSteps.keywordsSteps().addDefaultKeyword(keywordAdGroupId);
        Long id5 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        Long id6 = api.userSteps.keywordsSteps().addAutotargeting(autoTargetingAdGroupId1);
        Long id7 = api.userSteps.keywordsSteps().addAutotargeting(autoTargetingAdGroupId2);
        Long id8 = api.userSteps.keywordsSteps().addAutotargeting(autoTargetingAdGroupId3);
        Long id9 = api.userSteps.keywordsSteps().addDefaultKeyword(keywordAdGroupId2);
        Long id10 = api.userSteps.keywordsSteps().addDefaultKeyword(keywordAdGroupId2);
        Long id11 = api.userSteps.keywordsSteps().addAutotargeting(autoTargetingAdGroupId4);

        return Arrays.asList(new Object[][]{
                {"максимальный Limit", new Long[]{campaignId}, null, null, LimitOffsetMap.LIMIT_MAX_LENGTH, null, Arrays.asList(id1, id2, id3, id4, id5, id6, id7, id8), null},
                {"только Limit", new Long[]{campaignId}, null, null, 2L, null, Arrays.asList(id1, id2), 2L},
                {"только Offset", new Long[]{campaignId}, null, null, null, 5L, Arrays.asList(id6, id7, id8), null},

                {"начало списка", new Long[]{campaignId}, null, null, 2L, 0L, Arrays.asList(id1, id2), 2L},
                {"середина списка", new Long[]{campaignId}, null, null, 4L, 2L, Arrays.asList(id3, id4, id5, id6), 6L},
                {"конец списка", new Long[]{campaignId}, null, null, 2L, 6L, Arrays.asList(id7, id8), null},
                {"последний элемент и за пределами списка", new Long[]{campaignId}, null, null, 2L, 7L, Arrays.asList(id8), null},
                {"за пределами списка", new Long[]{campaignId}, null, null, 2L, 8L, Arrays.asList(), null},

                {"список фраз с нулевым Offset", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, null, 0L, Arrays.asList(id3, id4, id9, id10), null},
                {"начало списка фраз", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, 1L, 0L, Arrays.asList(id3), 1L},
                {"середина списка фраз", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, 2L, 1L, Arrays.asList(id4, id9), 3L},
                {"конец списка фраз", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, 1L, 3L, Arrays.asList(id10), null},
                {"последний элемент и за пределами списка фраз", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, 2L, 3L, Arrays.asList(id10), null},
                {"за пределами списка фраз", null, new Long[]{keywordAdGroupId,keywordAdGroupId2}, null, 2L, 4L, Arrays.asList(), null},

                {"список автотаргетингов с нулевым Offset", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, null, 0L, Arrays.asList(id6, id7, id8, id11), null},
                {"начало списка автотаргетингов", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, 1L, 0L, Arrays.asList(id6), 1L},
                {"середина списка автотаргетингов", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, 2L, 1L, Arrays.asList(id7, id8), 3L},
                {"конец списка автотаргетингов", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, 1L, 3L, Arrays.asList(id11), null},
                {"последний элемент и за пределами списка автотаргетингов", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, 2L, 3L, Arrays.asList(id11), null},
                {"за пределами списка автотаргетингов", null, new Long[]{autoTargetingAdGroupId1,autoTargetingAdGroupId2,autoTargetingAdGroupId3,autoTargetingAdGroupId4}, null, 2L, 4L, Arrays.asList(), null},

                {"выборочный список с нулевым Offset", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, null, 0L, Arrays.asList(id1, id3, id5, id7, id9, id11), null},
                {"начало выборочного списка", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, 2L, 0L, Arrays.asList(id1, id3), 2L},
                {"середина списка автотаргетинга", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, 2L, 2L, Arrays.asList(id5, id7), 4L},
                {"конец списка автотаргетинга", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, 2L, 4L, Arrays.asList(id9, id11), null},
                {"последний элемент и за пределами выборочного списка", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, 2L, 5L, Arrays.asList(id11), null},
                {"за пределами выборочного списка", null, null, new Long[]{id1, id3, id5, id7, id9, id11}, 2L, 6L, Arrays.asList(), null},
        });
    }

    @Test
    @TestCaseId("2713")
    public void bidsGetPage() {
        BidsSelectionCriteriaMap bidsSelectionCriteriaMap = new BidsSelectionCriteriaMap();
        if (campaignIds != null) {
            bidsSelectionCriteriaMap.withCampaignIds(campaignIds);
        }
        if (adGroupIds != null) {
            bidsSelectionCriteriaMap.withAdGroupIds(adGroupIds);
        }
        if (keywordIds != null) {
            bidsSelectionCriteriaMap.withKeywordIds(keywordIds);
        }

        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(bidsSelectionCriteriaMap)
                        .withFieldNames(BidFieldEnum.KEYWORD_ID)
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(limit)
                                        .withOffset(offset)
                        )
        );

        List<Long> gotIds = response.getBids().stream().map(BidActionResult::getKeywordId).collect(Collectors.toList());
        assertThat("вернулся правильный набор групп", gotIds, equalTo(expectedKeywordIds));

        assertThat("значение LimitedBy верное", response.getLimitedBy(), equalTo(limitedBy));
    }
}
