package ru.yandex.autotests.direct.api.bids.get;

import com.google.common.base.Joiner;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Негативная проверка обязательности полей.")
public class WithoutRequiredFieldsGetRequestTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1317")
    public void tryGetWithoutSelectionCriteriaTest() {
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.KEYWORD_ID.value()});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1318")
    public void tryGetWithoutFieldNamesTest() {
        JSONObject keywordIds = new JSONObject();
        keywordIds.put(capitalize(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                new Long[]{keywordId});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), keywordIds);
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)
                )
        );
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1319")
    public void tryGetWithoutIdsTest() {
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{BidFieldEnum.KEYWORD_ID.value()});
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new BidsSelectionCriteriaMap().getBean());
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsGet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4001,
                        Api5ErrorDetailsJava.IN_STRUCTURE_MUST_BE_ONE_OF_REQUIRED_FIELD,
                        path(GetRequestMap.SELECTION_CRITERIA),
                        Joiner.on(", ").join(
                                path(BidsSelectionCriteriaMap.KEYWORDS_IDS),
                                path(BidsSelectionCriteriaMap.ADGROUP_IDS),
                                path(BidsSelectionCriteriaMap.CAMPAIGN_IDS))
                )
        );
    }
}
