package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 10.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка наличия поля AuctionBids в ответе.")
@Tag(TagDictionary.TRUNK)
public class AuctionBidsFieldTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static String getResponse;
    private static long keywordID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public BidFieldEnum fieldName;

    @Parameterized.Parameter(value = 1)
    public Boolean isContained;

    @Parameterized.Parameters(name = "auctionBids = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidFieldEnum.AUCTION_BIDS, true},
               {BidFieldEnum.BID, false}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1321")
    public void callBidsGet(){
        getResponse = api.userSteps.jsonClientV5().sendRequest(
                ServiceNames.BIDS, client, Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(fieldName).getBean()
        );
        assertThat("AuctionBids возвращается в зависимости от значения входного параметра",
                getResponse.contains(capitalize(BidsGetItemMap.AUCTION_BIDS)),
                equalTo(isContained));
     }
}
