package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.lessThanOrEqualTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 17.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка убывания ставок и цен в AuctionBids")
@Tag(TagDictionary.TRUNK)
public class AuctionBidsPriceAndBidValueTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static long keywordID;
    private static List<AuctionBidItem> gotAuctionBid;
    private static GetResponse getResponse;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public AuctionBidsPositionForBids position;

    @Parameterized.Parameters(name = "Position = {0}")
    public static Collection positions() {
        List<Object[]> data = new ArrayList<Object[]>();
        for (AuctionBidsPositionForBids auctionBidsPosition : AuctionBidsPositionForBids.values()) {
            data.add(new Object[]{auctionBidsPosition});
        }
        return data;
    }


    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(client, adGroupID, "iphone4 купить");
        getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.AUCTION_BIDS)
        );
        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("вернулась структура AuctionBid",
                getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        gotAuctionBid = getResponse.getBids().get(0).getAuctionBids();
    }

    @Issue("DIRECT-45005")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1322")
    public void comparePriceAndBidInAuctionBid() {
        AuctionBidItem auctionBid = gotAuctionBid.stream()
                .filter(phraseActionBid -> phraseActionBid.getPosition().equals(position.toString()))
                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
        if (position.equals(AuctionBidsPositionForBids.P14) || position.equals(AuctionBidsPositionForBids.P24)) {
            assertThat("значение Bid равно значению Price",
                    auctionBid.getPrice(), equalTo(auctionBid.getBid()));
        } else {
            assertThat("значение Bid больше значения Price",
                    auctionBid.getPrice(), lessThanOrEqualTo(auctionBid.getBid()));
        }
    }
}
