package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Ordering;
import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.reverseOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 17.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка убывания ставок и цен в AuctionBids")
public class AuctionBidsSortTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordID;
    private static List<AuctionBidItem> gotAuctionBids;
    private static GetResponse getResponse;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(adGroupID, "купить часы дорого");
        getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.AUCTION_BIDS)
        );
        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("вернулась структура AuctionBid",
                getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        gotAuctionBids = getResponse.getBids().get(0).getAuctionBids();
    }

    @Issue("DIRECT-45005")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1323")
    public void checkSortForFieldBidInPremiumBlock() {
        List<Long> bids = gotAuctionBids.stream()
                .filter(gotActionBid -> gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P11.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P12.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P13.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P14.toString()))
                .map(AuctionBidItem::getBid)
                .collect(Collectors.toList());
        assertThat("значения Bid убывают", Ordering.from(reverseOrder()).isOrdered(bids), equalTo(true));
    }

    @Issue("DIRECT-45005")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1324")
    public void checkSortForFieldPriceInPremiumBlock() {
        List<Long> prices = gotAuctionBids.stream()
                .filter(gotActionBid -> gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P11.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P12.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P13.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P14.toString()))
                .map(AuctionBidItem::getPrice)
                .collect(Collectors.toList());
        assertThat("значения Price убывают", Ordering.from(reverseOrder()).isOrdered(prices), equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1325")
    public void checkSortForFieldBidInBlockBelowSearch() {
        List<Long> bids = gotAuctionBids.stream()
                .filter(gotActionBid -> gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P21.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P22.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P23.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P24.toString()))
                .map(AuctionBidItem::getBid)
                .collect(Collectors.toList());
        assertThat("значения Bid убывают", Ordering.from(reverseOrder()).isOrdered(bids), equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1326")
    public void checkSortForFieldPriceInBlockBelowSearch() {
        List<Long> prices = gotAuctionBids.stream()
                .filter(gotActionBid -> gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P21.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P22.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P23.toString())
                        || gotActionBid.getPosition().equals(AuctionBidsPositionForBids.P24.toString()))
                .map(AuctionBidItem::getPrice)
                .collect(Collectors.toList());
        assertThat("значения Price убывают", Ordering.from(reverseOrder()).isOrdered(prices), equalTo(true));
    }
}
