package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.AuctionBidItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 10.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка структуры AuctionBids в ответе.")
@Tag(TagDictionary.TRUNK)
public class AuctionBidsStructureTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static GetResponse getResponse;
    private static long keywordID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "Protocol = {0}")
    public static Collection protocol() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1327")
    public void callBidsGet(){
        getResponse = api.protocol(protocol).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.AUCTION_BIDS)
        );

        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("вернулась структура AuctionBid",
                getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        List<AuctionBidItem> gotAuctionBids = getResponse.getBids().get(0).getAuctionBids();
        AuctionBidsPositionForBids[] positions = AuctionBidsPositionForBids.values();
        List<AuctionBidItem> expectedAuctionBids =  Stream.of(positions)
                .map(position ->
                        (AuctionBidItem)
                                new AuctionBidItemMap()
                                        .withPosition(position.toString())
                                        .withBid(0l)
                                        .withPrice(0l).getBean()

                )
                .collect(Collectors.toList());
        MatchVariation variation = new DefaultMatchVariation().forClasses(Long.class).useMatcher(greaterThan(0l));
        assertThat("AuctionBids возвращается корректной структуры", gotAuctionBids,
                beanDiffer(expectedAuctionBids).withVariation(variation));
    }
}
