package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

/**
 * Created by ginger on 10.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка значений остальных полей при запросе с и без AuctionBids.")
@Tag(TagDictionary.TRUNK)
public class CompareWithAndWithoutAuctionBidsTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static GetResponse getResponseWithAuctionBids;
    private GetResponse getResponseWithoutAuctionBids;
    private static long keywordID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        api.as( BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordID)
                                        .withBid(3100000L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1328")
    public void callBidsGet(){
        getResponseWithAuctionBids = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(
                                BidFieldEnum.BID,
                                BidFieldEnum.CONTEXT_BID,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.STRATEGY_PRIORITY,
                                BidFieldEnum.COMPETITORS_BIDS,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.CONTEXT_COVERAGE,
                                BidFieldEnum.MIN_SEARCH_PRICE,
                                BidFieldEnum.CURRENT_SEARCH_PRICE,
                                BidFieldEnum.AUCTION_BIDS
                        )
        );
        getResponseWithoutAuctionBids = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(
                                BidFieldEnum.BID,
                                BidFieldEnum.CONTEXT_BID,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.STRATEGY_PRIORITY,
                                BidFieldEnum.COMPETITORS_BIDS,
                                BidFieldEnum.SEARCH_PRICES,
                                BidFieldEnum.CONTEXT_COVERAGE,
                                BidFieldEnum.MIN_SEARCH_PRICE,
                                BidFieldEnum.CURRENT_SEARCH_PRICE
                                )
        );
        assertThat("ставки совпадают",
                getResponseWithoutAuctionBids,
                beanDiffer(getResponseWithAuctionBids)
                        .fields(ignore(BidsGetItemMap.AUCTION_BIDS)));
    }
}
