package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 25.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-43571"),
        @Issue("https://st.yandex-team.ru/DIRECT-43821")})
@Description("Проверка маппинга CompetitorsBids в AuctionBids")
public class CompetitorsBidsWithAuctionBidsTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordID;
    private static List<AuctionBidItem> gotAuctionBids;
    private static GetResponse getResponse;
    private static List<Long> gotCompetitorsBids;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.COMPETITORS_BIDS, BidFieldEnum.AUCTION_BIDS)
        );
        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("вернулась структура AuctionBid",
                getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        assumeThat("вернулась структура CompetitorsBids",
                getResponse.getBids().get(0).getCompetitorsBids(), notNullValue());
        gotAuctionBids = getResponse.getBids().get(0).getAuctionBids();
        gotCompetitorsBids = getResponse.getBids().get(0).getCompetitorsBids();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1329")
    public void checkMappingOfCompetitorsBids() {
        List<Long> bids = gotAuctionBids.stream()
                .map(AuctionBidItem::getBid)
                .sorted((x, y) -> -x.compareTo(y))
                .collect(Collectors.toList());
        assertThat("получены верные CompetitorsBids", gotCompetitorsBids, equalTo(bids));
    }
}
