package ru.yandex.autotests.direct.api.bids.get.auctionbids;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.SearchPrices;
import com.yandex.direct.api.v5.general.PositionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 10.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-43571")
@Description("Проверка маппинга Prices из SearchPrices.")
public class SearchPricesWithAuctionBidsTest {
    public static String client = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static GetResponse getResponse;
    private static long keywordID;
    private static List<AuctionBidItem> auctionBids;
    private static List<SearchPrices> searchPrices;

    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public PositionEnum searchPricesPosition;

    @Parameterized.Parameter(1)
    public AuctionBidsPositionForBids auctionBidsPosition;

    @Parameterized.Parameters(name = "PositionEnum = {0}, AuctionBidsPosition = {1}")
    public static Collection protocol() {
        Object[][] data = new Object[][]{
                {PositionEnum.FOOTERFIRST, AuctionBidsPositionForBids.P21},
                {PositionEnum.FOOTERBLOCK, AuctionBidsPositionForBids.P24},
                {PositionEnum.PREMIUMFIRST, AuctionBidsPositionForBids.P11},
                {PositionEnum.PREMIUMBLOCK, AuctionBidsPositionForBids.P14}
        };
        return Arrays.asList(data);
    }
    @BeforeClass
    public static void prepareTesData(){
        api.userSteps.clientFakeSteps().enableAPI(client);
        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.AUCTION_BIDS, BidFieldEnum.SEARCH_PRICES)
        );
        assumeThat("вернулась 1 ставка", getResponse.getBids(), hasSize(1));
        assumeThat("вернулась структура AuctionBid",
                getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        assumeThat("вернулась структура SearchPrices",
                getResponse.getBids().get(0).getSearchPrices(), notNullValue());
        auctionBids = getResponse.getBids().get(0).getAuctionBids();
        searchPrices = getResponse.getBids().get(0).getSearchPrices();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1330")
    public void callBidsGet(){
        Long auctionFieldBid =
                auctionBids.stream()
                        .filter(auctionBid -> auctionBid.getPosition().equals(auctionBidsPosition.toString()))
                        .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой ставки")).getBid();
        Long priceFromSearchPrices =
                searchPrices.stream()
                        .filter(searchPrice -> searchPrice.getPosition().equals(searchPricesPosition))
                .findAny().orElseThrow(() -> new AssertionError("в SearchPrices нет требуемой Price")).getPrice();
        assertThat("верный маппинг для "+ searchPricesPosition, priceFromSearchPrices, equalTo(auctionFieldBid));

    }

}
