package ru.yandex.autotests.direct.api.bids.get.limit;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 18.02.15.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
@Description("Негативная проверка ограничений в SelectionCriteria.")
public class BidsGetNegativeLimitTest {
    private static String SUPER = BidsLogins.SUPER;
    private static String CLIENT = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;
    private static Long adGroupId;
    private static Long campaignId;

    @Rule
    public Trashman trashman = new Trashman(api);
    private Integer keywordsLimit = 10000;
    private Integer adGroupsLimit = 1000;
    private Integer campaignsLimit = 10;


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1331")
    public void getWithMoreThanMaxKeywordIdsInSelectionCriteria(){
        //testplan: string № 9
        //DIRECT-35103
        Long[] keywordIDs = new Long[keywordsLimit+1];
        Arrays.fill(keywordIDs, keywordId);
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.KEYWORDS_IDS),
                        keywordsLimit

                )
        );
    }

     // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1332")
    public void getWithMoreThanMaxAdGroupIdsInSelectionCriteria(){
        Long[] adGroupIDs = new Long[adGroupsLimit+1];
        Arrays.fill(adGroupIDs, adGroupId);
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(adGroupIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.ADGROUP_IDS),
                        adGroupsLimit

                )
        );
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1333")
    public void getWithMoreThanMaxCamapignIdsInSelectionCriteria(){
        Long[] campaignIDs = new Long[campaignsLimit+1];
        Arrays.fill(campaignIDs, campaignId);
        api.userSteps.bidsSteps().shouldGetErrorOnBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(GetRequestMap.SELECTION_CRITERIA, BidsSelectionCriteriaMap.CAMPAIGN_IDS),
                        campaignsLimit

                )
        );
    }

}
