package ru.yandex.autotests.direct.api.bids.get.limit;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
/**
 * Created by ginger on 15.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
@Description("Позитивная проверка ограничений в SelectionCriteria.")
public class BidsGetPositiveLimitTest {
    private static String SUPER = BidsLogins.SUPER;
    private static String CLIENT = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static Long adGroupId;
    private static long keywordId;

    @Rule
    public Trashman trashman = new Trashman(api);
    private Integer keywordsLimit = 10000;
    private Integer adGroupsLimit = 1000;
    private Integer campaignsLimit = 10;


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1334")
    public void getWithMaxKeywordIdsInSelectionCriteria(){
        //testplan: string № 9
        Long[] keywordIDs = new Long[keywordsLimit];
        Arrays.fill(keywordIDs, keywordId);
        GetResponse getResponse =  api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT
        );
        assertThat("вернулось правильное кол-во Bids",getResponse.getBids().size(),equalTo(1));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1335")
    public void getWithMaxAdGroupIdsInSelectionCriteria(){
        Long[] adGroupIDs = new Long[adGroupsLimit];
        Arrays.fill(adGroupIDs, adGroupId);
        GetResponse getResponse =  api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(adGroupIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT
        );
        assertThat("вернулось правильное кол-во Bids",getResponse.getBids().size(),equalTo(1));
    }

    // case after DIRECT-36010
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1336")
    public void getWithMaxCampaignIdsInSelectionCriteria(){
        Long[] campaignIDs = new Long[campaignsLimit];
        Arrays.fill(campaignIDs, campaignId);
        GetResponse getResponse =  api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignIDs)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT
        );
        assertThat("вернулось правильное кол-во Bids",getResponse.getBids().size(),equalTo(1));
    }


}
