package ru.yandex.autotests.direct.api.bids.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 16.02.18.
 * https://st.yandex-team.ru/DIRECT-69182#1518767129000
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Description("Позитивная проверка метода при нулевой ставке в БД (предполагаем, что 0).")
@Issue("https://st.yandex-team.ru/DIRECT-69182")
public class BidsSet0ValueTest {
    private static String CLIENT = BidsLogins.BIDS_CLIENT;
    private static long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @TestCaseId("2818")
    public void trySetBidEqual0Value(){
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withContextBid(0L)
                        ),
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(BidSetItemMap.CONTEXT_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))
                        )));
    }

    @Test
    @TestCaseId("2819")
    public void trySetContextBidEqual0Value(){
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(0L)
                        ),
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(BidSetItemMap.BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))
                        )));
    }
}

