package ru.yandex.autotests.direct.api.bids.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 27.01.17.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Issue("https://st.yandex-team.ru/DIRECT-62877")
public class BidsSetCheckRightsNotOwnCampaignNegativeTest {

    private static String agency = Logins.AGENCY_YE_DEFAULT;
    private static String sameShardSubclient1 = Logins.SAME_SHARD_SUBCLIENT1;
    private static String sameShardSubclient2 = Logins.SAME_SHARD_SUBCLIENT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agency);

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    private static Long campaignId;
    private static Long adGroupId;
    private static Long keywordId;
    private static Long autotargetingId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createKeyword(){
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        int subclientShard = jooqDbSteps.shardingSteps().getShardByLogin(sameShardSubclient1);
        assumeThat(
                "оба субклиента в одном шарде",
                jooqDbSteps.shardingSteps().getShardByLogin(sameShardSubclient2),
                equalTo(subclientShard)
        );

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(sameShardSubclient1);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, sameShardSubclient1);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(sameShardSubclient1, adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(sameShardSubclient1, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2684")
    public void checkRightsToSetByCid() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                    .withCampaignId(campaignId)
                                    .withBid(BID)
                        ),
                sameShardSubclient2,
                BidExpectedResult.errors(
                    new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                            capitalize(BidSetItemMap.CAMPAIGN_ID),
                            campaignId
                    )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2685")
    public void checkRightsToSetByAdGroupId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBid(BID)
                        ),
                sameShardSubclient2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.AD_GROUP_ID),
                                adGroupId
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2686")
    public void checkRightsToSetByKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(BID)
                        ),
                sameShardSubclient2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                keywordId
                        )
                )
        );
    }

    @Test
    @TestCaseId("2715")
    public void checkRightsToSetForAutotargetingByKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withBid(BID)
                        ),
                sameShardSubclient2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                autotargetingId
                        )
                )
        );
    }
}
