package ru.yandex.autotests.direct.api.bids.set;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

@Aqua.Test
@Features(BidsFeatures.SET)
@Issue("https://st.yandex-team.ru/DIRECT-69268")
public class BidsSetCpmBannerTest {

    private static final String CLIENT = BidsLogins.CLIENT_FOR_RUB;
    private static long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @TestCaseId("2808")
    public void setForCpmBannerId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withBid(MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue())),
                CLIENT,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("3047")
    public void setBidLessThanMin() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withBid(MoneyCurrency.get(Currency.RUB).getMinCpmPrice().getPrevious().bidLong()
                                        .longValue())),
                CLIENT,
                BidExpectedResult.errors(new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                        capitalize(BidsGetItemMap.BID),
                        (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().stringValue(MoneyFormat.INTEGER))));
    }

    @Test
    @TestCaseId("3048")
    public void setBidMoreThanMax() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withBid(MoneyCurrency.get(Currency.RUB).getMaxCpmPrice().getNext().bidLong()
                                        .longValue())),
                CLIENT,
                BidExpectedResult.errors(new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                        capitalize(BidsGetItemMap.BID),
                        (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                        MoneyCurrency.get(Currency.RUB).getMaxCpmPrice().bidLong().stringValue(MoneyFormat.INTEGER))));
    }
}
