package ru.yandex.autotests.direct.api.bids.set;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckWriteRightsInternalRolesNegativeTest {

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String bidsServClient = BidsLogins.BIDS_SERV_CLIENT;

    static Long servCampaignId;
    static Long autotargetingId;

    @Parameterized.Parameter(0)
    public String internalLogin;

    @Parameterized.Parameters(name = "internalLogin = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        Long servCampaignId = api.as(bidsServClient).userSteps.campaignSteps().addDefaultTextCampaign(bidsServClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.protocol(ProtocolType.JSON).userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1349")
    public void callBidsSet() {
        //testplan: string № 23
        //DIRECT-35028
        api.as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(BID)
                        ),
                bidsServClient,
                BidExpectedResult.errors(
                        new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)
                ));
    }

    @Test
    @TestCaseId("2717")
    public void callBidsSetForAutotargeting() {
        api.as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withBid(BID)
                        ),
                bidsServClient,
                BidExpectedResult.errors(
                        new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)
                ));
    }
}
