package ru.yandex.autotests.direct.api.bids.set;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckWriteRightsInternalRolesPositiveTest {

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String bidsServClient = BidsLogins.BIDS_SERV_CLIENT;
    private static String manager = Logins.MANAGER_DEFAULT;

    static Long autotargetingId;

    @Parameterized.Parameter(0)
    public String internalLogin;

    @Parameterized.Parameters(name = "internalLogin = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT},
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        Long servCampaignId = api.as(manager).userSteps.campaignSteps().addDefaultTextCampaign(bidsServClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId, bidsServClient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, bidsServClient);
        keywordId = api.protocol(ProtocolType.JSON).userSteps.keywordsSteps().addDefaultKeyword(bidsServClient, adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(bidsServClient, adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1350")
    public void callBidsSet() {
        //testplan: string № 23
        //DIRECT-35621
        api.as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(BID)
                        ),
                bidsServClient,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("2718")
    public void callBidsSetForAutotargeting() {
        api.as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap().withKeywordId(autotargetingId).withBid(BID)
                ),
                bidsServClient,
                BidExpectedResult.successWithKeywordId()
        );
    }
}
