package ru.yandex.autotests.direct.api.bids.set;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 07.11.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@RunWith(Parameterized.class)
public class CheckWriteRightsShardingTest {

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String agency = BidsLogins.BIDS_AGENCY_SHARD2;
    private static String subclientIn1Shard = BidsLogins.BIDS_SUBCLIENT_SHARD1;
    private static String subclientIn2Shard =  BidsLogins.BIDS_SUBCLIENT_SHARD2;

    @Parameterized.Parameter(0)
    public String subclient;
    private Long adGroupId;

    @Parameterized.Parameters(name = "subclient = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {subclientIn1Shard},
                {subclientIn2Shard},

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agency, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn1Shard, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn2Shard, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void readBanner(){
        Long servCampaignId = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId, subclient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, subclient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1351")
    public void checkRightsToWrite() {
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(subclient, adGroupId);
        api.as(agency).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(BID)
                        ),
                subclient,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("2719")
    public void checkRightsToWriteForAutotargeting() {
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(subclient, adGroupId);
        api.as(agency).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap().withKeywordId(autotargetingId).withBid(BID)
                ),
                subclient,
                BidExpectedResult.successWithKeywordId()
        );
    }
}
