package ru.yandex.autotests.direct.api.bids.set;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 17.10.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@RunWith(Parameterized.class)
public class CheckWriteRightsTest {

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String agencyWithSubclients = BidsLogins.BIDS_AGENCY_SHARD2;
    private static String subclient1 = BidsLogins.BIDS_SUBCLIENT_SHARD1;
    private static String subclient2 = BidsLogins.BIDS_SUBCLIENT_SHARD2;

    Integer campaignId;
    Long id;

    @Parameterized.Parameter(0)
    public String agency;

    @Parameterized.Parameter(1)
    public String subclient;

    @Parameterized.Parameter(2)
    public String secondOwner;

    @Parameterized.Parameter(3)
    public String subclientForSet;

    private Long adGroupId;

    @Parameterized.Parameters(name = "agency = {0}, subclient = {1}, secondOwner = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agencyWithSubclients, subclient1, agencyWithSubclients, subclient2, }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_AGENCY_SHARD2,ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT_SHARD1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT_SHARD2, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void readBanner(){
        Long campaignID = api.as(secondOwner).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        adGroupId = api.as(secondOwner).userSteps.adGroupsSteps().addDefaultGroup(campaignID, subclient);
        api.as(secondOwner).userSteps.adsSteps().addDefaultTextAd(adGroupId, subclient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1352")
    public void checkRightsToWrite() {
        Long keywordId = api.as(secondOwner).userSteps.keywordsSteps().addDefaultKeyword(subclient, adGroupId);
        api.as(agency).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(BID)
                        ),
                subclientForSet,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                keywordId
                        )));
    }

    @Test
    @TestCaseId("2720")
    public void checkRightsToWriteForAutotargeting() {
        Long autotargetingId = api.as(secondOwner).userSteps.keywordsSteps().addAutotargeting(subclient, adGroupId);
        api.as(agency).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap().withKeywordId(autotargetingId).withBid(BID)
                ),
                subclientForSet,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                autotargetingId
                        )
                )
        );
    }
}
