package ru.yandex.autotests.direct.api.bids.set;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Stories(ApiStories.JSON5)
public class InvalidFieldTypeSetRequestTest {
    private static LogSteps log = LogSteps.getLogger(InvalidFieldTypeSetRequestTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).version(104).as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;
    private static Long adGroupId;
    private static Long campaignID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1365")
    public void trySetBidsNotArray(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.BID),13l);
        bids.put(capitalize(BidSetItemMap.CONTEXT_BID),12l);
        bids.put(capitalize(BidSetItemMap.STRATEGY_PRIORITY), PriorityEnum.NORMAL);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS), bids);
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(SetRequestMap.BIDS)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1366")
    public void trySetKeywordIdWithQuotes(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID),String.valueOf(keywordId));
        bids.put(capitalize(BidSetItemMap.BID),13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1367")
    public void trySetKeywordIdStringValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID),"gingerValue");
        bids.put(capitalize(BidSetItemMap.BID),13l);
        bids.put(capitalize(BidSetItemMap.CONTEXT_BID),12l);
        bids.put(capitalize(BidSetItemMap.STRATEGY_PRIORITY), PriorityEnum.NORMAL);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.BIDS, BidSetItemMap.KEYWORD_ID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1368")
    public void trySetAdGroupIdWithQuotes(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.AD_GROUP_ID),String.valueOf(adGroupId));
        bids.put(capitalize(BidSetItemMap.BID),13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1369")
    public void trySetAdGroupIdStringValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.AD_GROUP_ID),"gingerValue");
        bids.put(capitalize(BidSetItemMap.BID),13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.BIDS, BidSetItemMap.AD_GROUP_ID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1370")
    public void trySetCampaignIdWithQuotes(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.CAMPAIGN_ID),String.valueOf(campaignID));
        bids.put(capitalize(BidSetItemMap.BID),13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1371")
    public void trySetCampaignIdStringValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.CAMPAIGN_ID),"gingerValue");
        bids.put(capitalize(BidSetItemMap.BID),13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.BIDS, BidSetItemMap.CAMPAIGN_ID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1373")
    public void trySetBidNotLongValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.BID),13.9f);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                // TODO DIRECT-73215
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                        "Bids.Bid"
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1375")
    public void trySetBidLongWithQuotes(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.BID),"13000000");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1376")
    public void trySetContextBidNotLongValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.CONTEXT_BID),12.6f);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                // TODO DIRECT-73215
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                        "Bids.ContextBid"
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1377")
    public void trySetContextBidLongWithQuotes(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.CONTEXT_BID),"13000000");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1378")
    public void trySetStrategyPriorityInvalidValue(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.STRATEGY_PRIORITY), "gingerValue");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        path(SetRequestMap.BIDS, BidSetItemMap.STRATEGY_PRIORITY),
                        Api5Error.enumAsParam(PriorityEnum.class)
                )
        );
    }

}
