package ru.yandex.autotests.direct.api.bids.set;


import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(BidsFeatures.SET)
@Description("Тесты на проверку округления ставок")
public class SetBidRoundingTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = BidsLogins.SUPER;

    private static long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    @SuppressWarnings("Duplicates")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.as(BidsLogins.BIDS_CLIENT).userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @TestCaseId("3087")
    public void setBidRoundUpTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withBid(143845000L)
                ),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getBid(), is(143850000L));
    }

    @Test
    @TestCaseId("3088")
    public void setContextBidRoundUpTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withContextBid(143845000L)
                ),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getContextBid(), is(143850000L));
    }

    @Test
    @TestCaseId("3089")
    public void setBidRoundDownTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withBid(143844999L)
                ),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getBid(), is(143840000L));
    }

    @Test
    @TestCaseId("3090")
    public void setContextBidRoundDownTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withContextBid(143844999L)
                ),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getContextBid(), is(143840000L));
    }
}
