package ru.yandex.autotests.direct.api.bids.set;

import com.google.common.base.Joiner;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 13.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
public class SetNegativeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String SUPER = BidsLogins.SUPER;
    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final String ANOTHER_CLIENT = BidsLogins.BIDS_ANOTHER_CLIENT;
    private static final MoneyCurrency CURRENCY_RUB = MoneyCurrency.get(Currency.RUB);
    private static final Long MAX_BID = CURRENCY_RUB.getLongMaxPrice().longValue();

    private static final Notification BID_MUST_NOT_BE_LESS_NOTIFICATION = new Notification(
            5005,
            Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
            capitalize(BidsGetItemMap.BID),
            CURRENCY_RUB.getNamePluralI(DirectTestRunProperties.getInstance().getDirectAPILocale().toLowerCase()),
            CURRENCY_RUB.getLongMinPrice().stringValue(MoneyFormat.INTEGER)
    );

    private static final Notification CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION = new Notification(
            5005,
            Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
            capitalize(BidsGetItemMap.CONTEXT_BID),
            CURRENCY_RUB.getNamePluralI(DirectTestRunProperties.getInstance().getDirectAPILocale().toLowerCase()),
            CURRENCY_RUB.getLongMinPrice().stringValue(MoneyFormat.INTEGER)
    );

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long negativeLong = -1L;
    private static Long adGroupId11;
    private static long keywordId11;
    private static Long autotargetingId;
    private static Long adGroupId12;
    private static Long adGroupId21;
    private static long keywordId21;
    private static Long anotherAdGroupId;
    private static long anotherkeywordId;
    private static Long anotherAutotargetingId;
    private static Long archiveAdGroupId;
    private static long archivekeywordId;
    private static Long archiveAutotargetingId;
    private static Long deletedAdGroupId;
    private static long deletedkeywordId;
    private static Long deletedAutotargetingId;
    private static Long deletedCampaignAutotargetingId;
    private static Long campaignId1;
    private static Long campaignId2;
    private static Long anotherCampaignId;
    private static Long deletedCampaignId;
    private static Long archiveCampaignId;
    private static long keywordId12;


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                CLIENT
        );
        adGroupId11 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId11, CLIENT);
        keywordId11 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId11);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, adGroupId11);

        adGroupId12 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId12, CLIENT);
        keywordId12 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId12);
        deletedAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, adGroupId12);
        api.userSteps.keywordsSteps().keywordsDelete(CLIENT, deletedAutotargetingId);
        //Вторая кампания клиента с одной фразой
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId21 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId21, CLIENT);
        keywordId21 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId21);

        //Чужая кампания
        anotherCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupId, ANOTHER_CLIENT);
        anotherkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, anotherAdGroupId);
        anotherAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(ANOTHER_CLIENT, anotherAdGroupId);

        //Архивная кампания
        archiveCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        archiveAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archiveCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(archiveAdGroupId, ANOTHER_CLIENT);
        archivekeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, archiveAdGroupId);
        archiveAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(ANOTHER_CLIENT, archiveAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(ANOTHER_CLIENT, archiveCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(ANOTHER_CLIENT, archiveCampaignId);

        //Удаленная кампания
        deletedCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(deletedAdGroupId, CLIENT);
        deletedkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, deletedAdGroupId);
        deletedCampaignAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, deletedAdGroupId);
        api.userSteps.campaignSteps().campaignsDelete(CLIENT, deletedCampaignId);
        api.protocol(ProtocolType.SOAP);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1384")
    public void trySetNullParams() {
        //testplan: string №25
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap(),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SetRequestMap.BIDS))
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1385")
    public void trySetValidAndInvalidBids() {
        //testplan: string №29
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId11)
                                .withBid(MAX_BID)
                                .withContextBid(MAX_BID),
                        new BidSetItemMap()
                                .withKeywordId(1L)
                                .withBid(MAX_BID)),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId(),
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                1)
                        ))
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1386")
    public void trySetOneInvalidBids() {
        //testplan: string №31
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(negativeLong)
                                        .withContextBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(BidSetItemMap.KEYWORD_ID)))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1387")
    public void trySetBidsForArchivedCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(archiveCampaignId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.CAMPAIGN_ID),
                                archiveCampaignId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1388")
    public void trySetBidsForDeletedCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(deletedCampaignId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.CAMPAIGN_ID),
                                deletedCampaignId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1389")
    public void trySetBidsForArchivedAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withAdGroupId(archiveAdGroupId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.AD_GROUP_ID),
                                archiveAdGroupId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1390")
    public void trySetBidsForDeletedAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withAdGroupId(deletedAdGroupId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.AD_GROUP_ID),
                                deletedAdGroupId))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1391")
    public void trySetBidsForArchivedKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(archivekeywordId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                archivekeywordId))
                ));
    }

    @Test
    @TestCaseId("2723")
    public void trySetBidsForArchivedAutotargetingId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(archiveAutotargetingId)
                                        .withBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                archiveAutotargetingId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1392")
    public void trySetBidsForDeletedKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(deletedkeywordId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                deletedkeywordId)))
        );
    }

    @Test
    @TestCaseId("2724")
    public void trySetBidsForDeletedAutotargetingId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(deletedAutotargetingId)
                                        .withBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                deletedAutotargetingId)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1392")
    public void trySetBidsForDeletedCampaignAutotargetingId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(deletedCampaignAutotargetingId)
                                        .withBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                deletedCampaignAutotargetingId)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1382")
    public void trySetBidsWithAdGroupIDAndKeywordID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withBid(MAX_BID),
                                new BidSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1383")
    public void trySetBidsWithAdGroupIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withBid(MAX_BID),
                                new BidSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1393")
    public void trySetBidsWithKeywordIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withBid(MAX_BID),
                                new BidSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1394")
    public void trySetBidsWithAdGroupIDAndKeywordIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withBid(MAX_BID),
                                new BidSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withBid(MAX_BID),
                                new BidSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1395")
    public void trySetBidsWithAdGroupIDAndKeywordIDAndCampaignIDInOneElement() {
        //testplan: string №32
        //DIRECT-35062 ,DIRECT-33872
        //   https://st.yandex-team.ru/DIRECT-35104
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withBid(MAX_BID)
                                        .withCampaignId(campaignId2)
                                        .withAdGroupId(adGroupId21)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                joinWithComma(
                                        path(BidsGetItemMap.KEYWORD_ID),
                                        path(BidsGetItemMap.AD_GROUP_ID),
                                        path(BidsGetItemMap.CAMPAIGN_ID))))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1396")
    public void trySetWithoutStrategyPriorityAndBidAndContextBid() {
        //testplan: string №57
        //https://st.yandex-team.ru/DIRECT-33874
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId11)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5008, Api5ErrorDetails.AT_LEAST_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                joinWithComma(
                                        path(BidsGetItemMap.BID),
                                        path(BidsGetItemMap.CONTEXT_BID),
                                        path(BidsGetItemMap.STRATEGY_PRIORITY))))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1397")
    public void trySetBidEqual0() {
        //testplan: string №42
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2725")
    public void trySetBidEqual0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1398")
    public void trySetEmptyArrayOfBids() {
        //testplan: string №27
        //https://st.yandex-team.ru/DIRECT-33677
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap(),
                                new BidSetItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        capitalize(KeywordBidsGetItemMap.KEYWORD_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.CAMPAIGN_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.AD_GROUP_ID)));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1399")
    public void trySetSomeValidBidsForSameKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId12)
                                .withBid(MAX_BID),
                        new BidSetItemMap()
                                .withKeywordId(keywordId11)
                                .withBid(MAX_BID),
                        new BidSetItemMap()
                                .withKeywordId(keywordId11)
                                .withContextBid(MAX_BID)),
                BidsLogins.BIDS_CLIENT,
                new BidExpectedResult().successWithKeywordId(),
                new BidExpectedResult().errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                new BidExpectedResult().errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId12)
                        )
                        .withFieldNames(
                                BidFieldEnum.KEYWORD_ID,
                                BidFieldEnum.BID),
                BidsLogins.BIDS_CLIENT
        );
        BidsGetItemMap expectedElement = new BidsGetItemMap()
                .withBid(MAX_BID)
                .withKeywordId(keywordId12);
        assertThat("вернулась правильная ставка", getResponse.getBids().toArray(),
                IsApiBeanCollectionContaining.hasItems(beanDiffer(expectedElement.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1400")
    public void trySetBidLessThen0() {
        //testplan: string №42
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2726")
    public void trySetBidLessThen0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1401")
    public void trySetContextBidLessThen0() {
        //testplan: string №48
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withContextBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2727")
    public void trySetContextBidLessThen0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withContextBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1402")
    public void trySetBidsNull() {
        //testplan: string №26
        //https://st.yandex-team.ru/DIRECT-33677
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withBids(new BidSetItemMap()),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        capitalize(KeywordBidsGetItemMap.KEYWORD_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.CAMPAIGN_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.AD_GROUP_ID))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1403")
    public void trySetContextBidEqual0() {
        //testplan: string №48
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withContextBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2728")
    public void trySetContextBidEqual0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withContextBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1404")
    public void trySetOneValidAndOneWithoutRequiredFieldsBidsTest() {
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId11)
                                .withBid(MAX_BID),
                        new BidSetItemMap()
                                .withAdGroupId(adGroupId11)),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1405")
    public void trySetBidsForAnotherClientCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(anotherCampaignId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.CAMPAIGN_ID),
                                anotherCampaignId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1406")
    public void trySetBidsForAnotherClientAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withAdGroupId(anotherAdGroupId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.AD_GROUP_ID),
                                anotherAdGroupId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1407")
    public void trySetBidsForAnotherClientKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(anotherkeywordId)
                                        .withBid(MAX_BID)
                                        .withContextBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                anotherkeywordId))
                ));
    }

    @Test
    @TestCaseId("2729")
    public void trySetBidsForAnotherClientAutotargetingId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(anotherAutotargetingId)
                                        .withBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                anotherAutotargetingId))
                ));
    }

    private static String joinWithComma(Path... paths) {
        return Joiner.on(", ").join(paths);
    }

}
