package ru.yandex.autotests.direct.api.bids.set;

import java.util.Arrays;
import java.util.Collections;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 13.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
public class SetPositiveTest {

    private static final Long MIN_BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();
    private static final Long BID1 = MIN_BID * 2L;
    private static final Long BID2 = BID1 * 2L;
    private static final Long BID3 = BID2 * 2L;
    private static final Long BID4 = BID3 * 2L;
    private static final Long BID5 = BID4 * 2L;
    private static final Long BID6 = BID5 * 2L;
    private static final Long BID7 = BID6 * 2L;
    private static final Long BID8 = BID7 * 2L;

    private static Long adGroupId1;
    private static Long adGroupId2;
    private static long keywordId1;
    private static long keywordId2;
    private static Long autotargetingId;
    private static Long campaignID;
    private static Long campaignIDWithAutoStrategy;
    private static long keywordId22;
    private static Long autotargetingId2;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().setAPIUnits(BidsLogins.BIDS_CLIENT, 12000000);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignID = api.as(BidsLogins.BIDS_CLIENT).userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId1);
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId2);

        campaignIDWithAutoStrategy = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault()
        );
        Long adGroupId3 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignIDWithAutoStrategy);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId3);
        keywordId22 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId3);
        autotargetingId2 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId3);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1408")
    public void setOnlyBid() {
        //testplan: string № 51
        //https://st.yandex-team.ru/DIRECT-33874
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBid(BID1),
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withBid(BID2)
                        ),
                BidExpectedResult.successWithKeywordId(),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordId1, autotargetingId)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId1).withBid(BID1).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID2).getBean()
                        )
                )
        );
    }

    @Test
    @TestCaseId("1409")
    public void setOnlyContextBid() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId1)
                                        .withContextBid(BID1),
                                new BidSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withContextBid(BID2)
                        ),
                BidExpectedResult.successWithKeywordId(),
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordId1, autotargetingId)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID)
        );
        assertThat("получили правильные значения ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId1).withContextBid(BID1).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId).withContextBid(BID2).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1409")
    public void setOnlyContextBidByCampaignId() {
        //testplan: string № 56, 49
        //https://st.yandex-team.ru/DIRECT-33874
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withContextBid(BID3)
                        ),
                BidExpectedResult.successWithCampaignId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID)
        );
        assertThat("получили правильные значения ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId1).withContextBid(BID3).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId).withContextBid(BID3).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId2).withContextBid(BID3).getBean()
                        )
                )
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1410")
    public void setOneValidBidsWithCampaignId() {
        //testplan: string №38
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withCampaignId(campaignID)
                                .withBid(BID3)
                                .withContextBid(BID4)
                ),
                new BidExpectedResult().successWithCampaignId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid и ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId1).withBid(BID3).withContextBid(BID4).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID3).withContextBid(BID4).getBean(),
                                new BidsGetItemMap().withKeywordId(keywordId2).withBid(BID3).withContextBid(BID4).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1411")
    public void setOneValidBidsWithAdGroupId() {
        //testplan: string №39
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withAdGroupId(adGroupId1)
                                .withBid(BID5)
                                .withContextBid(BID6)),
                new BidExpectedResult().successWithAdGroupId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withAdGroupIds(adGroupId1)
                        ).withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid и ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId1).withBid(BID5).withContextBid(BID6).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID5).withContextBid(BID6).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1412")
    public void setOneValidBidsWithKeywordId() {
        //testplan: string №30 № 40
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId2)
                                .withBid(BID7)
                                .withContextBid(BID8)
                ),
                new BidExpectedResult().successWithKeywordId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId2)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid и ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Collections.singletonList(
                                new BidsGetItemMap().withKeywordId(keywordId2).withBid(BID7).withContextBid(BID8).getBean()
                        )
                )
        );
    }

    @Test
    @TestCaseId("2730")
    public void setOneValidBidsWithAutotargetingId() {
        //testplan: string №30 № 40
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(autotargetingId)
                                .withBid(BID8)
                                .withContextBid(BID7)
                ),
                new BidExpectedResult().successWithKeywordId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGetByKeywordIdsWithFields(
                Arrays.asList(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.BID),
                autotargetingId
        );
        assertThat("получили правильные значения Bid и ContextBid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID8).withContextBid(BID7).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1413")
    public void setSomeValidWithDifferentFieldsBids() {
        //testplan: string №30
        // https://st.yandex-team.ru/DIRECT-35879
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap()
                                .withKeywordId(keywordId1)
                                .withContextBid(BID7),
                        new BidSetItemMap()
                                .withKeywordId(autotargetingId)
                                .withBid(BID8),
                        new BidSetItemMap()
                                .withKeywordId(keywordId22)
                                .withStrategyPriority(PriorityEnum.HIGH),
                        new BidSetItemMap()
                                .withKeywordId(autotargetingId2)
                                .withStrategyPriority(PriorityEnum.HIGH)
                ),
                new BidExpectedResult().successWithKeywordId(),
                new BidExpectedResult().successWithKeywordId(),
                new BidExpectedResult().successWithKeywordId(),
                new BidExpectedResult().successWithKeywordId()
        );
    }

}
