package ru.yandex.autotests.direct.api.bids.set;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Stories(ApiStories.JSON5)
public class UnknownFieldSetRequestTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adGroupId;
    private static long keywordId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId,BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1422")
    public void unknownFieldInRequest(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.BID),12000000L);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        params.put("gingerField",":)");
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        "gingerField"
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1423")
    public void unknownFieldInSelectionCriteria(){
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetItemMap.BID),13000000L);
        bids.put("gingerField",":)");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        capitalize(SetAutoRequestMap.BIDS), "gingerField"
                )
        );
    }

}
