package ru.yandex.autotests.direct.api.bids.set;

import java.sql.Timestamp;
import java.time.LocalDateTime;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsBaseRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 13.04.17.
 */

@Aqua.Test
@Features(BidsFeatures.SET)
@Description("Проверка изменения статусов группы и автотаргетинга после изменения ставки на поиске")
public class UpdatingStatusBsSyncAfterChangeBidForAutotargetingTest {

    private static final Long BID1= MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;
    private static final Long BID2 = BID1 * 2L;
    private static final Timestamp YESTERDAY = Timestamp.valueOf(LocalDateTime.now().minusDays(1).withNano(0));

    private static final String LOGIN = BidsLogins.BIDS_CLIENT;
    private static Long adGroupId;
    private static BidsBaseRecord actualBidsBaseRecord;
    private static DirectJooqDbSteps dbSteps;
    private static PhrasesRecord adGroupRecord;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void addUnitsToClient() {
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultServingOff()
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargetingWithBidsAndStrategyPriority(adGroupId, BID1, BID1, PriorityEnum.NORMAL);

        adGroupRecord = dbSteps.adGroupsSteps().getPhrases(adGroupId)
                .setLastchange(YESTERDAY).setStatusbssynced(PhrasesStatusbssynced.Yes);
        dbSteps.adGroupsSteps().updatePhrases(adGroupRecord);
        assumeThat("группе установились ожидаемые параметры",
                dbSteps.adGroupsSteps().getPhrases(adGroupId),
                equalTo(adGroupRecord)
        );

        BidsBaseRecord originalBidsBaseRecord = dbSteps.bidsBaseSteps().getBidsBaseByBidId(autotargetingId)
                .setLastchange(YESTERDAY);
        dbSteps.bidsBaseSteps().updateBidsBase(originalBidsBaseRecord);
        assumeThat("автотаргетингу установились ожидаемые параметры",
                dbSteps.bidsBaseSteps().getBidsBaseByBidId(autotargetingId),
                equalTo(originalBidsBaseRecord)
        );

        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap().withBids(
                        new BidSetItemMap().withKeywordId(autotargetingId).withBid(BID2)
                ),
                BidExpectedResult.successWithKeywordId()
        );

        actualBidsBaseRecord = dbSteps.bidsBaseSteps().getBidsBaseByBidId(autotargetingId);

    }

    @Test
    @TestCaseId("2735")
    public void checkAdGroups() {
        assertThat("параметры группы не обновились", dbSteps.adGroupsSteps().getPhrases(adGroupId), equalTo(adGroupRecord));
    }

    @Test
    @TestCaseId("2734")
    public void checkBidsModtime() {
        assertThat("у автотаргетинга обновился modtime", actualBidsBaseRecord.getLastchange(), greaterThan(YESTERDAY));
    }
}
