package ru.yandex.autotests.direct.api.bids.set.limit;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 18.02.15.
 */
@Aqua.Test
@Features(BidsFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
public class SetPositiveLimitTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private long keywordId;
    private Long campaignId;
    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1436")
    public void successSetMaxAmountCampaignID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetItemMap[] bidsWithCampaignID = new BidSetItemMap[10];
        Arrays.fill(bidsWithCampaignID, new BidSetItemMap()
                .withCampaignId(campaignId)
                .withBid(111000L)
        );
        BidExpectedResult[] expectedResults = new BidExpectedResult[10];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(bidsWithCampaignID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1437")
    public void successSetMaxAmountAdGroupID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetItemMap[] bidsWithAdGroupID = new BidSetItemMap[1000];
        Arrays.fill(bidsWithAdGroupID, new BidSetItemMap()
                .withAdGroupId(adGroupId)
                .withBid(111000L)
        );
        BidExpectedResult[] expectedResults = new BidExpectedResult[1000];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(bidsWithAdGroupID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1438")
    public void successForMaxAmountKeywordID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetItemMap[] bidsWithKeywordID = new BidSetItemMap[10000];
        Arrays.fill(bidsWithKeywordID, new BidSetItemMap()
                .withKeywordId(keywordId)
                .withBid(1110000L));
        BidExpectedResult[] expectedResults = new BidExpectedResult[10000];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(bidsWithKeywordID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }
}
