package ru.yandex.autotests.direct.api.bids.set.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 01.10.14.
 */

@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SetBidsManualOnSearchAndMaximumCoverageOnContextStrategyTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    private Long campaignID;
    private long keywordId;
    private Long autoTargetingId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"HIGHEST_POSITION + MAXIMUM_COVERAGE",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition()}
        });
    }


    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                searchStrategy,
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autoTargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1443")
    public void setBidTest(){
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withBid(BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );

        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId).withBid(BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingId).withBid(BID).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1444")
    public void setContextBidTest(){
        api.as( BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withContextBid(BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.CONTEXT_BID)
        );
        assertThat("получили правильные значения Bid",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId).withContextBid(BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingId).withContextBid(BID).getBean()
                        )
                )
        );
    }

}
