package ru.yandex.autotests.direct.api.bids.set.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.ObjectFactory;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 02.10.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SetPriorityAutoOnSearchAndDefaultOnContextStrategyTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategy;

    private Long campaignID;
    private static final Long goalID = MetrikaGoals.getGoalForLogin(CLIENT);
    private Long keywordId;
    private Long autoTargetingId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"WB_MAXIMUM_CLICKS + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB)},
                {"WB_MAXIMUM_CONVERSION_RATE + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, goalID.longValue())},
                {"AVERAGE_CPC + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB)},
                {"AVERAGE_CPA + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, goalID.longValue())}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignID =  api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .addCampMetrikaGoals(campaignID, goalID.longValue(), 200L, 0L);
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(
                new CampaignUpdateItemMap()
                .withId(campaignID)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault()))));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autoTargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1452")
    public void setStrategyPriorityTest(){
        //DIRECT-35445
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withStrategyPriority(PriorityEnum.HIGH)
                        ),
                BidExpectedResult.successWithCampaignId()
        );

        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.STRATEGY_PRIORITY)
        );
        assertThat("получили правильные значения StrategyPriority",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId).withStrategyPriority(
                                        new ObjectFactory().createBidGetItemStrategyPriority(PriorityEnum.HIGH)
                                ).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingId).withStrategyPriority(
                                        new ObjectFactory().createBidGetItemStrategyPriority(PriorityEnum.HIGH)
                                ).getBean()
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1451")
    public void setBidAndContextBidAndStrategyPriorityTest(){
        // DIRECT-35448
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withBid(BID)
                                        .withContextBid(BID)
                                        .withStrategyPriority(PriorityEnum.HIGH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.warningsWithCampaignID(
                        new Notification(10160,
                                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                capitalize(BidSetItemMap.BID)),
                        new Notification(
                                10160,
                                Api5ErrorDetailsJava.BID_WILL_NOT_APPLIED_BECAUSE_OF_NETWORK_DEPENDS_ON_SEARCH,
                                capitalize(BidSetItemMap.CONTEXT_BID))
                                ));
    }
}
