package ru.yandex.autotests.direct.api.bids.set.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.base.Joiner;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.ObjectFactory;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 01.10.14.
 */

@Aqua.Test
@Features(BidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SetPriorityManualOnSearchAndMaximumCoverageOnContextStrategyTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final Long BID1 = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;
    private static final Long BID2 = BID1 * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    private Long campaignID;
    private Long keywordId;
    private Long autoTargetingId;

    @Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"HIGHEST_POSITION + MAXIMUM_COVERAGE",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition()}
        });
    }


    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                searchStrategy,
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autoTargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1456")
    public void setStrategyPriorityTest(){
        //DIRECT-35445,  DIRECT-35478
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withStrategyPriority(PriorityEnum.HIGH)
                        ),

                BidExpectedResult.warningWithError(
                        new Notification(10161,
                                Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                path(BidSetItemMap.STRATEGY_PRIORITY)),
                        new Notification(9600,
                                Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_FOR_STRATEGY,
                                Joiner.on(", ").join(
                                        path(BidSetItemMap.BID),
                                        path(BidSetItemMap.CONTEXT_BID))))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1455")
    public void setBidAndContextBidAndStrategyPriorityTest() {
        // DIRECT-35448
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withBid(BID1)
                                        .withContextBid(BID2)
                                        .withStrategyPriority(PriorityEnum.HIGH)
                        ),
                BidExpectedResult.warningsWithCampaignID(
                        new Notification(10161, Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(BidSetItemMap.STRATEGY_PRIORITY))
                )
        );

        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.STRATEGY_PRIORITY)
        );
        assertThat("получили правильные значения Bid, ContextBid и StrategyPriority",
                getResponse.getBids(),
                beanDifferV5(
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(keywordId).withBid(BID1).withContextBid(BID2).withStrategyPriority(
                                        new ObjectFactory().createBidGetItemStrategyPriority(PriorityEnum.NORMAL)
                                ).getBean(),
                                new BidsGetItemMap().withKeywordId(autoTargetingId).withBid(BID1).withContextBid(BID2).withStrategyPriority(
                                        new ObjectFactory().createBidGetItemStrategyPriority(PriorityEnum.NORMAL)
                                ).getBean()
                        )
                )
        );
    }
}
