package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 27.01.17.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Issue("https://st.yandex-team.ru/DIRECT-62877")
public class BidsSetAutoCheckRightsNotOwnCampaignNegativeTest {

    private static final String AGENCY = Logins.AGENCY_YE_DEFAULT;
    private static final String SAME_SHARD_SUBCLIENT_1 = Logins.SAME_SHARD_SUBCLIENT1;
    private static final String SAME_SHARD_SUBCLIENT_2 = Logins.SAME_SHARD_SUBCLIENT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long keywordId;
    private static Long autotargetingId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createKeyword(){
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        int subclientShard = jooqDbSteps.shardingSteps().getShardByLogin(SAME_SHARD_SUBCLIENT_1);
        assumeThat(
                "оба субклиента в одном шарде",
                jooqDbSteps.shardingSteps().getShardByLogin(SAME_SHARD_SUBCLIENT_2),
                equalTo(subclientShard)
        );

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(SAME_SHARD_SUBCLIENT_1);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, SAME_SHARD_SUBCLIENT_1);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(SAME_SHARD_SUBCLIENT_1, adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(SAME_SHARD_SUBCLIENT_1, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2690")
    public void checkRightsToSetAutoByCid() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                    .withCampaignId(campaignId)
                                    .withScope(ScopeEnum.NETWORK)
                                    .withContextCoverage(20)
                        ),
                SAME_SHARD_SUBCLIENT_2,
                BidExpectedResult.errors(
                    new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                            capitalize(BidSetItemMap.CAMPAIGN_ID),
                            campaignId
                    )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2691")
    public void checkRightsToSetAutoByAdGroupId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withScope(ScopeEnum.NETWORK)
                                        .withContextCoverage(20)
                        ),
                SAME_SHARD_SUBCLIENT_2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.AD_GROUP_ID),
                                adGroupId
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2692")
    public void checkRightsToSetAutoByKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId)
                                        .withScope(ScopeEnum.NETWORK)
                                        .withContextCoverage(20)
                        ),
                SAME_SHARD_SUBCLIENT_2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                keywordId
                        )
                )
        );
    }

    @Test
    @TestCaseId("2749")
    public void checkRightsToSetAutoByKeywordIdForAutotargeting() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withScope(ScopeEnum.NETWORK)
                                        .withContextCoverage(20)
                        ),
                SAME_SHARD_SUBCLIENT_2,
                BidExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(BidSetItemMap.KEYWORD_ID),
                                autotargetingId
                        )
                )
        );
    }
}
