package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 27.01.17.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Issue("https://st.yandex-team.ru/DIRECT-55967")
public class BidsSetAutoForAbnormalArchivedCampaignNegativeTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    private static final DirectJooqDbSteps JOOQ_DB_STEPS = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long keywordId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createKeyword(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        CampaignsRecord campaignsRecord = JOOQ_DB_STEPS.campaignsSteps().getCampaignById(campaignId);
        JOOQ_DB_STEPS.campaignsSteps().updateCampaigns(campaignsRecord.setArchived(CampaignsArchived.Yes));
    }

    @AfterClass
    public static void fixCampaign(){
        CampaignsRecord campaignsRecord = JOOQ_DB_STEPS.campaignsSteps().getCampaignById(campaignId);
        JOOQ_DB_STEPS.campaignsSteps().updateCampaigns(campaignsRecord.setArchived(CampaignsArchived.No));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2693")
    public void checkRightsToSetAutoByCid() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                    .withCampaignId(campaignId)
                                    .withScope(ScopeEnum.NETWORK)
                                    .withContextCoverage(20)
                        ),
                BidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2694")
    public void checkRightsToSetAutoByAdGroupId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withScope(ScopeEnum.NETWORK)
                                        .withContextCoverage(20)
                        ),
                BidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2695")
    public void checkRightsToSetAutoByKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId)
                                        .withScope(ScopeEnum.NETWORK)
                                        .withContextCoverage(20)
                        ),
                BidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }
}
