package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 01.06.15.
 */
@Aqua.Test
@Stories(ApiStories.UNITS)
@Issue("https://st.yandex-team.ru/DIRECT-37056")
@Features(BidsFeatures.SET_AUTO)
@Description("Проверка списания баллов.")
public class BidsSetAutoUnitsTest {
    private static String client = BidsLogins.UNITS_SET_AUTO_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adGroupId1;
    private static long keywordId11;
    private static long keywordId12;
    private static long keywordId2;
    private static Long campaignId2;

    @Rule
    public Trashman trashman = new Trashman(api);

    static Long campaignId1;

    private static final int SET_AUTO_COST = 25;
    private static final int SET_AUTO_COST_KEYWORD = 0;

    private static final int DEFAULT_ERROR_COST = 20;
    private static final int DEFAULT_FAULT_COST = 50;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                client
        );
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, client);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId1, client);
        keywordId11 = api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId1);
        keywordId12 = api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId1);

        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                client
        );
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2, client);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId2, client);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId2);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1459")
    public void setAutoOneBid() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ), client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + SET_AUTO_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1460")
    public void setAutoWithError() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId11)
                                        .withPosition(PositionEnum.FOOTERBLOCK)
                                        .withContextCoverage(10)
                                        .withCalculateBy(CalculateByEnum.DIFF)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withPosition(PositionEnum.FOOTERBLOCK)
                                        .withContextCoverage(10)
                                        .withCalculateBy(CalculateByEnum.DIFF)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                client,
                BidExpectedResult.successWithKeywordId(),
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(BidSetAutoItemMap.KEYWORD_ID)))
                ));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + DEFAULT_ERROR_COST + SET_AUTO_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1461")
    public void setAutoTwoBids() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId12)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 2 * SET_AUTO_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1462")
    public void setAutoOneAdGroupBids() {
        // DIRECT-38677
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 2 * SET_AUTO_COST_KEYWORD));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1463")
    public void setAutoTwoCampaignBids() {
        //DIRECT-38677
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().bidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId2)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 6 * SET_AUTO_COST_KEYWORD));
    }

    //FAULT

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1464")
    public void trySetAutoNullParams() {
        //   https://st.yandex-team.ru/DIRECT-38565
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap(),
                client,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SetAutoRequestMap.BIDS))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(DEFAULT_FAULT_COST));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1465")
    public void setAutoWithNotEnoughUnitsForActionButNotEmptyUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, unitsBefore);
        unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("доступные баллы пользователя", unitsBefore, equalTo(0));
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ), client,
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION));
    }

}
