package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Collections;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 13.06.17.
 */

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
public class CheckStatusBsSyncAfterSetAutoForAutotargetingTest {

    private static final String LOGIN = BidsLogins.BIDS_CLIENT;
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();

    private static Long adGroupId;
    private static Long autotargetingId;
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargetingWithBid(adGroupId, MAX_BID);
        assumeThat("у автотаргетинга минимальная ставка",
                api.userSteps.bidsSteps()
                        .bidsGetByKeywordIdsWithFields(Collections.singletonList(BidFieldEnum.BID), autotargetingId)
                        .getBids().get(0).getBid(),
                equalTo(MAX_BID)
        );
    }

    @Test
    @TestCaseId("2750")
    public void statusBsSyncAfterSetAutoBidsTest(){
        api.userSteps.phrasesFakeSteps().setPhraseStatusBsSyncedYes(adGroupId);
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(600)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withMaxBid(MAX_BID/2)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidExpectedResult.successWithAdGroupId()
        );
        assumeThat("у автотаргетинга ставка поменялась",
                api.userSteps.bidsSteps()
                        .bidsGetByKeywordIdsWithFields(Collections.singletonList(BidFieldEnum.BID), autotargetingId)
                        .getBids().get(0).getBid(),
                not(equalTo(MAX_BID))
        );
    }
}
