package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesSetAutoNegativeTest {

    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String bidsServClient = BidsLogins.BIDS_SERV_CLIENT;

    private Long adGroupId;

    @Parameterized.Parameter(0)
    public String internalLogin;

    @Parameterized.Parameters(name = "internalLogin = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        };
        return Arrays.asList(data);
    }

    @Before
    public void prepareData() {
        Long servCampaignId = api.as(bidsServClient).userSteps.campaignSteps().addDefaultTextCampaign(bidsServClient);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId, bidsServClient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1468")
    public void callBidsSetAuto() {
        //testplan: string № 104
        //https://st.yandex-team.ru/DIRECT-35028
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.protocol(ProtocolType.SOAP).as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(MAX_BID)
                                .withScope(ScopeEnum.SEARCH)
                ),
                bidsServClient,
                BidExpectedResult.errors(
                        new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1468")
    public void callBidsSetAutoForAutotargeting() {

        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP).as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(autotargetingId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(MAX_BID)
                                .withScope(ScopeEnum.SEARCH)
                ),
                bidsServClient,
                BidExpectedResult.errors(
                        new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)
                ));
    }
}
