package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesSetAutoPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String bidsServClient = BidsLogins.BIDS_SERV_CLIENT;
    private static String manager = Logins.MANAGER_DEFAULT;

    static Long servCampaignId;

    @Parameterized.Parameter(0)
    public String internalLogin;

    @Parameterized.Parameters(name = "internalLogin = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT},
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        servCampaignId = api.as(manager).userSteps.campaignSteps().addDefaultTextCampaign(bidsServClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId, bidsServClient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, bidsServClient);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(bidsServClient, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1469")
    public void callBidsSetAuto() {
        //testplan: string № 104
        // DIRECT-35621
        api.as(internalLogin).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                bidsServClient,
                BidExpectedResult.successWithKeywordId());
    }
}
