package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
public class InvalidFieldTypeSetAutoRequestTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(Logins.SUPER_LOGIN);
    private static String invalidStringValue = "gingerValue";
    private static Long adGroupId;
    private static Long campaignID;
    private static long keywordId;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1470")
    public void trySetBidsNotArray() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), bids);
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(SetAutoRequestMap.BIDS)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1471")
    public void trySetKeywordIdWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), String.valueOf(keywordId));
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1472")
    public void trySetKeywordIdStringValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.KEYWORD_ID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1473")
    public void trySetAdGroupIdWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.AD_GROUP_ID), String.valueOf(adGroupId));
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1474")
    public void trySetAdGroupIdStringValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.AD_GROUP_ID), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.AD_GROUP_ID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1475")
    public void trySetCampaignIdWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.CAMPAIGN_ID), String.valueOf(campaignID));
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1476")
    public void trySetMaxBidWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), "10000000");
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1477")
    public void trySetMaxBidStringValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), invalidStringValue);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.MAX_BID)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1478")
    public void trySetIncreasePercentStringValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.INCREASE_PERCENT)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1479")
    public void trySetIncreasePercentWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), "50");
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1480")
    public void trySetCalculateByInvalidValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.CALCULATE_BY),
                        Api5Error.enumAsParam(CalculateByEnum.class)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1481")
    public void trySetScopeInvalidValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{invalidStringValue});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.SCOPE),
                        Api5Error.enumAsParam(ScopeEnum.class)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1482")
    public void trySetScopeNotArray() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), ScopeEnum.SEARCH);
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.SCOPE)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1483")
    public void trySetContextCoverageStringValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.CONTEXT_COVERAGE)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1484")
    public void trySetContextCoverageWithQuotes() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), "3");
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetBidResultOnJson(
                Action.SET_AUTO,
                BidsLogins.BIDS_CLIENT,
                params,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1485")
    public void trySetPositionInvalidValue() {
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), invalidStringValue);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT), 50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE), 3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID), 10000000L);
        params.put(capitalize(SetAutoRequestMap.BIDS), new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        path(SetAutoRequestMap.BIDS, BidSetAutoItemMap.POSITION),
                        Api5Error.enumAsParam(PositionEnum.class)
                )
        );
    }


}
