package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 24.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class MaxBidFieldInvalidCurrencyValueTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String currencyLogin;

    @Parameterized.Parameter(1)
    public Long valueOfMaxBid;

    @Parameterized.Parameter(2)
    public Notification notification;
    private long keywordId;

    @Parameterized.Parameters(name = "currencyLogin = {0}, valueOfMaxBid = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_CLIENT_UAH,
                        MoneyCurrency.get(Currency.UAH).getMinPrice().getPrevious().bidLong().longValue(),   //значения меньше минимальной ставки
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.UAH).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.UAH).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_KZT,
                        MoneyCurrency.get(Currency.KZT).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.KZT).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.KZT).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_EUR,
                        MoneyCurrency.get(Currency.EUR).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.EUR).getAbbreviation(api.locale())),
                                MoneyCurrency.get(Currency.EUR).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_CHF,
                        MoneyCurrency.get(Currency.CHF).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.CHF).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.CHF).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_TRY,
                        MoneyCurrency.get(Currency.TRY).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.TRY).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.TRY).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_RUB,
                        MoneyCurrency.get(Currency.RUB).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_USD,
                        MoneyCurrency.get(Currency.USD).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.USD).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.USD).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.CLIENT_BYN,
                        MoneyCurrency.get(Currency.BYN).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.BYN).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.BYN).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_UAH,
                        MoneyCurrency.get(Currency.UAH).getMaxPrice().getNext().bidLong().longValue(),                     //значения больше максимальной ставки на шаг торгов
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.UAH).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.UAH).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_KZT,
                        MoneyCurrency.get(Currency.KZT).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.KZT).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.KZT).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_EUR,
                        MoneyCurrency.get(Currency.EUR).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.EUR).getAbbreviation(api.locale())),
                                MoneyCurrency.get(Currency.EUR).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_CHF,
                        MoneyCurrency.get(Currency.CHF).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.CHF).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.CHF).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_TRY,
                        MoneyCurrency.get(Currency.TRY).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.TRY).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.TRY).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_RUB,
                        MoneyCurrency.get(Currency.RUB).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.BIDS_CLIENT_USD,
                        MoneyCurrency.get(Currency.USD).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.USD).getNameCasusDativus(api.locale())),
                                MoneyCurrency.get(Currency.USD).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {BidsLogins.CLIENT_BYN,
                        MoneyCurrency.get(Currency.BYN).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.BYN).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.BYN).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createDate() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(currencyLogin);
        Long campaignId = api.as(currencyLogin).userSteps.campaignSteps().addDefaultTextCampaign(currencyLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, currencyLogin);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1486")
    public void trySetInvalidValueInDifferentCurrency() {
        //testplan: string № 79, 80
        //https://st.yandex-team.ru/DIRECT-35279
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(valueOfMaxBid)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                currencyLogin,
                BidExpectedResult.errors(notification));
    }
}
