package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 24.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class MaxBidFieldValidCurrencyValueTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String currencyLogin;

    @Parameterized.Parameter(1)
    public Long valueOfMaxBid;
    private long keywordId;

    @Parameterized.Parameters(name = "currencyLogin = {0}, valueOfMaxBid = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_CLIENT_UAH, MoneyCurrency.get(Currency.UAH).getMinPrice().bidLong().longValue()},       //минимальные допустимые ставки
                {BidsLogins.BIDS_CLIENT_KZT, MoneyCurrency.get(Currency.KZT).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_EUR, MoneyCurrency.get(Currency.EUR).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_CHF, MoneyCurrency.get(Currency.CHF).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_TRY, MoneyCurrency.get(Currency.TRY).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_RUB, MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_USD, MoneyCurrency.get(Currency.USD).getMinPrice().bidLong().longValue()},
                {BidsLogins.CLIENT_BYN, MoneyCurrency.get(Currency.BYN).getMinPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_UAH, MoneyCurrency.get(Currency.UAH).getMaxPrice().bidLong().longValue()},  //максимальные допустимые ставки
                {BidsLogins.BIDS_CLIENT_KZT, MoneyCurrency.get(Currency.KZT).getMaxPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_EUR, MoneyCurrency.get(Currency.EUR).getMaxPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_CHF, MoneyCurrency.get(Currency.CHF).getMaxPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_TRY, MoneyCurrency.get(Currency.TRY).getMaxPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_RUB, MoneyCurrency.get(Currency.RUB).getMaxPrice().bidLong().longValue()},
                {BidsLogins.BIDS_CLIENT_USD, MoneyCurrency.get(Currency.USD).getMaxPrice().bidLong().longValue()},
                {BidsLogins.CLIENT_BYN, MoneyCurrency.get(Currency.BYN).getMaxPrice().bidLong().longValue()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createDate() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(currencyLogin);
        campaignId = api.as(currencyLogin).userSteps.campaignSteps().addDefaultTextCampaign(currencyLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, currencyLogin);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1487")
    public void callBidsSetWithValueInDifferentCurrency() {
        //testplan: string № 78, 80
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMBLOCK)
                                .withIncreasePercent(30)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(4)
                                .withMaxBid(valueOfMaxBid)
                                .withScope(ScopeEnum.SEARCH)
                ),
                currencyLogin,
                BidExpectedResult.successWithCampaignId()
        );
    }
}
