package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 16.10.14.
 */

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class RequiredFieldsInSetAutoPriceTest {
    private static Long adGroupId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1489")
    public void trySoapSetAutoWithoutScope(){
        //testplans string №99
        api.protocol(ProtocolType.SOAP).userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(SetAutoRequestMap.BIDS), capitalize(BidSetAutoItemMap.SCOPE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1490")
    public void tryJsonSetAutoWithoutScope(){
        //testplans string №99
        api.protocol(ProtocolType.JSON).userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(SetAutoRequestMap.BIDS), capitalize(BidSetAutoItemMap.SCOPE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1491")
    public void trySetAutoWithNetworkScopeAndWithoutContextCoverage(){
        //testplans string №95
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(9600, Api5ErrorDetails.FOR_UPDATING_BIDS_ON_NETWORK_SHOULD_SPECIFIED,
                                capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE),
                                ScopeEnum.NETWORK.value().toLowerCase())
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1488")
    public void trySetAutoWithSearchScopeAndWithoutPosition(){
        //testplans string №82
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(9600, Api5ErrorDetails.FOR_UPDATING_BIDS_ON_SEARCH_SHOULD_SPECIFIED,
                                capitalize(BidSetAutoItemMap.POSITION))
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1492")
    public void trySetAutoWithSearchScopeAndWithoutCalculateBy(){
        //testplans string №91
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(9600, Api5ErrorDetails.FOR_UPDATING_BIDS_ON_SEARCH_SHOULD_SPECIFIED_IF,
                                capitalize(BidSetAutoItemMap.CALCULATE_BY),
                                capitalize(BidSetAutoItemMap.INCREASE_PERCENT))
                )
        );
    }

}
